/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.context;

import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.conversation.context.HttpConversationUtil;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ConversationCleanupListener
implements HttpSessionListener {
    private static Logger LOG = LoggerFactory.getLogger(ConversationCleanupListener.class);

    public ConversationCleanupListener() {
        LOG.info("Conversation Cleanup Listener created.");
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        ConversationContextManager contextManager = HttpConversationUtil.getContextManager(se.getSession());
        if (contextManager != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleaning up conversation resources for session with ID:  " + se.getSession().getId());
            }
            contextManager.destroy();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleanup of conversation resources completed for session with ID:  " + se.getSession().getId());
            }
        }
    }
}

