/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.configuration;

import com.google.code.rees.scope.conversation.annotations.BeginConversation;
import com.google.code.rees.scope.conversation.annotations.ConversationAction;
import com.google.code.rees.scope.conversation.annotations.ConversationController;
import com.google.code.rees.scope.conversation.annotations.ConversationField;
import com.google.code.rees.scope.conversation.annotations.EndConversation;
import com.google.code.rees.scope.conversation.configuration.ConversationArbitrator;
import com.google.code.rees.scope.struts2.ActionUtil;
import com.google.code.rees.scope.util.NamingUtil;
import com.google.code.rees.scope.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DefaultConversationArbitrator
implements ConversationArbitrator {
    private static final long serialVersionUID = -1577464106543589370L;
    protected String actionSuffix = "Controller";

    @Override
    public void setActionSuffix(String suffix) {
        this.actionSuffix = suffix;
    }

    @Override
    public Collection<Field> getCandidateConversationFields(Class<?> clazz) {
        HashSet<Field> conversationFields = new HashSet<Field>();
        for (Field field : ReflectionUtil.getFields(clazz)) {
            if (!field.isAnnotationPresent(ConversationField.class)) continue;
            conversationFields.add(field);
        }
        return conversationFields;
    }

    @Override
    public Collection<Method> getCandidateConversationMethods(Class<?> clazz) {
        HashSet<Method> conversationMethods = new HashSet<Method>();
        for (Method method : ReflectionUtil.getMethods(clazz)) {
            if (method.isAnnotationPresent(ConversationAction.class) || method.isAnnotationPresent(BeginConversation.class) || method.isAnnotationPresent(EndConversation.class)) {
                conversationMethods.add(method);
                continue;
            }
            if (!this.isConversationController(clazz) || !this.isAction(method)) continue;
            conversationMethods.add(method);
        }
        return conversationMethods;
    }

    @Override
    public Collection<String> getConversations(Class<?> clazz, Field field) {
        HashSet<String> fieldConversations = new HashSet<String>();
        if (field.isAnnotationPresent(ConversationField.class)) {
            ConversationField conversationField = field.getAnnotation(ConversationField.class);
            String[] conversations = conversationField.conversations();
            if (conversations.length == 0) {
                conversations = this.getConversationsWithInheritance(clazz, this.actionSuffix);
            }
            fieldConversations.addAll(Arrays.asList(conversations));
        }
        return fieldConversations;
    }

    @Override
    public Collection<String> getConversations(Class<?> clazz, Method method) {
        HashSet<String> methodConversations = new HashSet<String>();
        if (method.isAnnotationPresent(ConversationAction.class)) {
            ConversationAction conversationmethod = method.getAnnotation(ConversationAction.class);
            String[] conversations = conversationmethod.conversations();
            if (conversations.length == 0) {
                conversations = this.getConversationsWithInheritance(clazz, this.actionSuffix);
            }
            methodConversations.addAll(Arrays.asList(conversations));
        } else {
            methodConversations.addAll(Arrays.asList(this.getConversationsWithInheritance(clazz, this.actionSuffix)));
        }
        return methodConversations;
    }

    @Override
    public String getName(Field field) {
        ConversationField conversationField;
        String annotationName;
        String name = field.getName();
        if (field.isAnnotationPresent(ConversationField.class) && !(annotationName = (conversationField = field.getAnnotation(ConversationField.class)).name()).equals("default")) {
            name = annotationName;
        }
        return name;
    }

    @Override
    public String getName(Method method) {
        return method.getName();
    }

    @Override
    public Collection<String> getBeginConversations(Class<?> clazz, Method method) {
        HashSet<String> methodConversations = new HashSet<String>();
        Class<?> declaringClass = method.getDeclaringClass();
        if (method.isAnnotationPresent(BeginConversation.class)) {
            BeginConversation conversationmethod = method.getAnnotation(BeginConversation.class);
            methodConversations.addAll(Arrays.asList(conversationmethod.conversations()));
            if (declaringClass.equals(clazz) && methodConversations.size() == 0) {
                methodConversations.addAll(Arrays.asList(this.getConversationsWithoutInheritance(clazz, this.actionSuffix)));
            }
        } else if (declaringClass.equals(clazz) && method.getName().startsWith("begin")) {
            methodConversations.addAll(Arrays.asList(this.getConversationsWithoutInheritance(clazz, this.actionSuffix)));
        } else if (!declaringClass.equals(clazz)) {
            methodConversations.addAll(this.getBeginConversations(declaringClass, method));
        }
        return methodConversations;
    }

    @Override
    public Collection<String> getEndConversations(Class<?> clazz, Method method) {
        HashSet<String> methodConversations = new HashSet<String>();
        Class<?> declaringClass = method.getDeclaringClass();
        if (method.isAnnotationPresent(EndConversation.class)) {
            EndConversation conversationmethod = method.getAnnotation(EndConversation.class);
            methodConversations.addAll(Arrays.asList(conversationmethod.conversations()));
            if (declaringClass.equals(clazz) && methodConversations.size() == 0) {
                methodConversations.addAll(Arrays.asList(this.getConversationsWithoutInheritance(clazz, this.actionSuffix)));
            }
        } else if (declaringClass.equals(clazz) && method.getName().startsWith("end")) {
            methodConversations.addAll(Arrays.asList(this.getConversationsWithoutInheritance(clazz, this.actionSuffix)));
        } else if (!declaringClass.equals(clazz)) {
            methodConversations.addAll(this.getEndConversations(declaringClass, method));
        }
        return methodConversations;
    }

    public Collection<String> getConversations(Class<?> clazz) {
        return this.getConversations(clazz, "Controller");
    }

    public Collection<String> getConversations(Class<?> clazz, String actionSuffix) {
        HashSet<String> conversations = new HashSet<String>();
        for (Method method : ReflectionUtil.getMethods(clazz)) {
            conversations.addAll(this.getConversations(clazz, method, actionSuffix));
        }
        return conversations;
    }

    public Collection<String> getConversations(Class<?> clazz, Method method, String actionSuffix) {
        HashSet<String> methodConversations = new HashSet<String>();
        if (method.isAnnotationPresent(ConversationAction.class)) {
            ConversationAction conversationmethod = method.getAnnotation(ConversationAction.class);
            String[] conversations = conversationmethod.conversations();
            if (conversations.length == 0) {
                conversations = this.getConversationsWithInheritance(clazz, actionSuffix);
            }
            methodConversations.addAll(Arrays.asList(conversations));
        } else if (this.isAction(method)) {
            methodConversations.addAll(Arrays.asList(this.getConversationsWithInheritance(clazz, actionSuffix)));
        }
        return methodConversations;
    }

    protected String[] getConversationsWithInheritance(Class<?> clazz, String actionSuffix) {
        ArrayList<String> conversations = new ArrayList<String>();
        for (Class<?> conversationControllerClass : this.getConversationControllers(clazz)) {
            conversations.addAll(Arrays.asList(this.getConversationsWithoutInheritance(conversationControllerClass, actionSuffix)));
        }
        return conversations.toArray(new String[0]);
    }

    protected String[] getConversationsWithoutInheritance(Class<?> clazz, String actionSuffix) {
        ArrayList<String> conversations = new ArrayList<String>();
        if (clazz.isAnnotationPresent(ConversationController.class)) {
            ConversationController controller = clazz.getAnnotation(ConversationController.class);
            String[] newConversations = controller.conversations();
            if (controller.value().equals("DEFAULT_VALUE")) {
                if (newConversations.length == 0) {
                    newConversations = new String[]{NamingUtil.getConventionName(clazz, actionSuffix)};
                }
            } else {
                conversations.add(controller.value());
            }
            conversations.addAll(Arrays.asList(newConversations));
        }
        return conversations.toArray(new String[0]);
    }

    protected Set<Class<?>> getConversationControllers(Class<?> clazz) {
        Class<?> superClass;
        HashSet annotatedClasses = new HashSet();
        for (Class<?> clazzClass : clazz.getInterfaces()) {
            if (!clazzClass.isAnnotationPresent(ConversationController.class)) continue;
            annotatedClasses.add(clazzClass);
        }
        if (clazz.isAnnotationPresent(ConversationController.class)) {
            annotatedClasses.add(clazz);
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            annotatedClasses.addAll(this.getConversationControllers(superClass));
        }
        return annotatedClasses;
    }

    protected boolean isAction(Method method) {
        return ActionUtil.isAction(method);
    }

    protected boolean isConversationController(Class<?> clazz) {
        return this.getConversationControllers(clazz).size() > 0;
    }
}

