/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.util.thread;

import com.google.code.rees.scope.util.thread.EasyThread;

public abstract class AbstractEasyThread
implements EasyThread {
    protected volatile Thread thread = new Thread(new Runner(this));
    protected boolean isRunning = false;

    protected AbstractEasyThread() {
    }

    @Override
    public synchronized void start() {
        if (!this.isRunning) {
            this.isRunning = true;
            this.thread.start();
        }
    }

    @Override
    public synchronized void stop() {
        this.isRunning = false;
    }

    @Override
    public synchronized void destroy() {
        this.stop();
        Thread dieingThread = this.thread;
        this.thread = null;
        if (dieingThread != null) {
            dieingThread.interrupt();
        }
    }

    protected abstract void doWhileRunning();

    class Runner
    implements Runnable {
        private AbstractEasyThread owner;

        protected Runner(AbstractEasyThread owner) {
            this.owner = owner;
        }

        @Override
        public void run() {
            while (this.owner.isRunning) {
                this.owner.doWhileRunning();
                Thread.yield();
            }
        }
    }
}

