/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.util.monitor;

import com.google.code.rees.scope.util.monitor.BladeRunner;
import com.google.code.rees.scope.util.monitor.TimeoutListener;
import com.google.code.rees.scope.util.monitor.TimeoutMonitor;
import com.google.code.rees.scope.util.monitor.TimeoutRunner;
import com.google.code.rees.scope.util.monitor.Timeoutable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorTimeoutMonitor<T extends Timeoutable<T>>
implements TimeoutMonitor<T>,
TimeoutListener<T> {
    private static final long serialVersionUID = -1502605748762224777L;
    public static final long MONITORING_DELAY = 1000L;
    protected Map<String, TimeoutRunner<T>> timeoutRunners = new HashMap<String, TimeoutRunner<T>>();
    protected transient Map<String, ScheduledFuture<?>> scheduledFutures = null;
    protected transient ScheduledExecutorService scheduler = null;
    protected long monitoringFrequency = 300000L;

    protected ScheduledExecutorTimeoutMonitor() {
    }

    @Override
    public void setMonitoringFrequency(long frequencyMillis) {
        this.monitoringFrequency = frequencyMillis;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        if (this.scheduler == null) {
            this.scheduler = scheduler;
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Map<String, TimeoutRunner<T>> map = this.timeoutRunners;
        synchronized (map) {
            if (this.scheduledFutures == null) {
                this.scheduledFutures = new HashMap();
            }
            for (Map.Entry<String, TimeoutRunner<T>> entry : this.timeoutRunners.entrySet()) {
                String targetId = entry.getKey();
                ScheduledFuture<?> future = this.scheduledFutures.get(targetId);
                if (future != null) continue;
                future = this.scheduler.scheduleAtFixedRate(entry.getValue(), 1000L, this.monitoringFrequency, TimeUnit.MILLISECONDS);
                this.scheduledFutures.put(targetId, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Map<String, TimeoutRunner<T>> map = this.timeoutRunners;
        synchronized (map) {
            for (ScheduledFuture<?> future : this.scheduledFutures.values()) {
                future.cancel(true);
            }
            this.scheduledFutures.clear();
            this.timeoutRunners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeoutable(T timeoutable) {
        Map<String, TimeoutRunner<T>> map = this.timeoutRunners;
        synchronized (map) {
            String targetId = timeoutable.getId();
            if (!this.timeoutRunners.containsKey(targetId)) {
                BladeRunner<T> timeoutRunner = BladeRunner.create(timeoutable);
                this.timeoutRunners.put(targetId, timeoutRunner);
                ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(timeoutRunner, 1000L, this.monitoringFrequency, TimeUnit.MILLISECONDS);
                this.scheduledFutures.put(targetId, future);
                timeoutable.addTimeoutListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimeoutable(T timeoutable) {
        Map<String, TimeoutRunner<T>> map = this.timeoutRunners;
        synchronized (map) {
            String targetId = timeoutable.getId();
            ScheduledFuture<?> future = this.scheduledFutures.remove(targetId);
            if (future != null) {
                future.cancel(true);
            }
            this.timeoutRunners.remove(targetId);
        }
    }

    @Override
    public void onTimeout(T timeoutable) {
        this.removeTimeoutable(timeoutable);
    }

    public static <TT extends Timeoutable<TT>> ScheduledExecutorTimeoutMonitor<TT> spawnInstance(ScheduledExecutorService scheduler, long monitoringFrequency) {
        ScheduledExecutorTimeoutMonitor monitor = new ScheduledExecutorTimeoutMonitor();
        monitor.setMonitoringFrequency(monitoringFrequency);
        monitor.setScheduler(scheduler);
        return monitor;
    }
}

