/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.util.monitor;

import com.google.code.rees.scope.util.monitor.TimeoutListener;
import com.google.code.rees.scope.util.monitor.TimeoutMonitor;
import com.google.code.rees.scope.util.monitor.TimeoutTask;
import com.google.code.rees.scope.util.monitor.Timeoutable;
import com.google.code.rees.scope.util.monitor.WaitTask;
import com.google.code.rees.scope.util.thread.BasicTaskThread;
import com.google.code.rees.scope.util.thread.TaskThread;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class BasicTimeoutMonitor<T extends Timeoutable<T>>
implements TimeoutMonitor<T>,
TimeoutListener<T> {
    private static final long serialVersionUID = -7924540987291582366L;
    protected Map<String, TimeoutTask> timeoutTasks;
    protected transient TaskThread taskThread;
    protected WaitTask waiter;
    protected long monitoringFrequency = 300000L;

    protected BasicTimeoutMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        this.waiter = WaitTask.create(this.monitoringFrequency);
        this.taskThread = BasicTaskThread.spawnInstance();
        this.taskThread.addTask(this.waiter);
        if (this.timeoutTasks == null) {
            this.timeoutTasks = new HashMap<String, TimeoutTask>();
        }
        Map<String, TimeoutTask> map = this.timeoutTasks;
        synchronized (map) {
            for (TimeoutTask task : this.timeoutTasks.values()) {
                this.taskThread.addTask(task);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.taskThread != null) {
            this.taskThread.destroy();
        }
        if (this.timeoutTasks != null) {
            this.timeoutTasks.clear();
        }
    }

    @Override
    public void setMonitoringFrequency(long frequencyMillis) {
        this.monitoringFrequency = frequencyMillis;
        if (this.waiter != null) {
            this.waiter.setWait(this.monitoringFrequency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeoutable(T timeoutable) {
        if (!this.timeoutTasks.containsKey(timeoutable.getId())) {
            timeoutable.addTimeoutListener(this);
            TimeoutTask task = TimeoutTask.create(timeoutable);
            Map<String, TimeoutTask> map = this.timeoutTasks;
            synchronized (map) {
                this.timeoutTasks.put(timeoutable.getId(), task);
            }
            this.taskThread.addTask(task);
        }
    }

    @Override
    public void removeTimeoutable(T timeoutable) {
        this.taskThread.removeTask(this.timeoutTasks.remove(timeoutable.getId()));
    }

    @Override
    public void onTimeout(T timeoutable) {
        this.timeoutTasks.remove(timeoutable.getId());
    }

    public static <TT extends Timeoutable<TT>> BasicTimeoutMonitor<TT> spawnInstance() {
        BasicTimeoutMonitor monitor = new BasicTimeoutMonitor();
        monitor.init();
        return monitor;
    }

    public static <TT extends Timeoutable<TT>> BasicTimeoutMonitor<TT> spawnInstance(long frequencyMillis) {
        BasicTimeoutMonitor monitor = new BasicTimeoutMonitor();
        monitor.setMonitoringFrequency(frequencyMillis);
        monitor.init();
        return monitor;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.taskThread.destroy();
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.init();
    }
}

