/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2;

import com.google.code.rees.scope.ActionProvider;
import com.google.code.rees.scope.conversation.annotations.ConversationController;
import com.google.code.rees.scope.conversation.configuration.DefaultConversationArbitrator;
import com.google.code.rees.scope.struts2.ModelDrivenConversationSupport;
import com.google.code.rees.scope.util.NamingUtil;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrutsConversationArbitrator
extends DefaultConversationArbitrator {
    private static final long serialVersionUID = 6842124082407418415L;
    private static final Logger LOG = LoggerFactory.getLogger(StrutsConversationArbitrator.class);
    private Map<Class<?>, Collection<String>> packageBasedConversations = Collections.synchronizedMap(new HashMap());
    protected boolean usePackageNesting;
    protected ActionProvider actionProvider;

    @Inject(value="conversation.package.nesting")
    public void setUsePackageNesting(String usePackageNesting) {
        this.usePackageNesting = "true".equals(usePackageNesting);
    }

    @Inject(value="struts.scope.actionFinder")
    public void setActionProvider(ActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    @Override
    protected Set<Class<?>> getConversationControllers(Class<?> clazz) {
        if (this.isModelDrivenConversation(clazz)) {
            Set<Class<?>> controllers = super.getConversationControllers(clazz);
            controllers.add(clazz);
            return controllers;
        }
        return super.getConversationControllers(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] getConversationsWithInheritance(Class<?> clazz, String actionSuffix) {
        ArrayList<String> conversations = new ArrayList<String>();
        conversations.addAll(Arrays.asList(super.getConversationsWithInheritance(clazz, actionSuffix)));
        if (this.usePackageNesting) {
            Map<Class<?>, Collection<String>> map = this.packageBasedConversations;
            synchronized (map) {
                Collection<String> packageConversations = this.packageBasedConversations.get(clazz);
                if (packageConversations == null) {
                    packageConversations = this.getPackageBasedConversations(clazz, actionSuffix);
                    this.packageBasedConversations.put(clazz, packageConversations);
                }
                conversations.addAll(packageConversations);
            }
        }
        return conversations.toArray(new String[0]);
    }

    @Override
    protected String[] getConversationsWithoutInheritance(Class<?> clazz, String actionSuffix) {
        ArrayList<String> conversations = new ArrayList<String>(Arrays.asList(super.getConversationsWithoutInheritance(clazz, actionSuffix)));
        if (this.isModelDrivenConversation(clazz) && !clazz.isAnnotationPresent(ConversationController.class)) {
            conversations.add(NamingUtil.getConventionName(clazz, actionSuffix));
        }
        return conversations.toArray(new String[0]);
    }

    @Override
    protected boolean isConversationController(Class<?> clazz) {
        return this.getConversationControllers(clazz).size() > 0 || this.isModelDrivenConversation(clazz);
    }

    protected boolean isModelDrivenConversation(Class<?> clazz) {
        return ModelDrivenConversationSupport.class.isAssignableFrom(clazz) && !clazz.equals(ModelDrivenConversationSupport.class);
    }

    protected Collection<String> getPackageBasedConversations(Class<?> clazz, String actionSuffix) {
        String className = clazz.getName();
        LOG.debug("Getting package-based conversations for " + className);
        String classPackageString = className.substring(0, className.lastIndexOf("."));
        HashSet<String> packageBasedConversations = new HashSet<String>();
        for (Class<?> superCandidate : this.actionProvider.getActionClasses()) {
            String superCandidateClassName = superCandidate.getName();
            String superCandidateClassPackageString = superCandidateClassName.substring(0, superCandidateClassName.lastIndexOf("."));
            if (!classPackageString.contains(superCandidateClassPackageString) || classPackageString.equals(superCandidateClassPackageString)) continue;
            LOG.debug("Adding conversations from " + superCandidateClassName);
            String[] superCandidateConversations = this.getConversationsWithoutInheritance(superCandidate, actionSuffix);
            packageBasedConversations.addAll(Arrays.asList(superCandidateConversations));
        }
        LOG.debug("Package-based conversations found for " + className + ":  " + ((Object)packageBasedConversations).toString());
        return packageBasedConversations;
    }
}

