/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2;

import com.google.code.rees.scope.ActionProvider;
import com.google.code.rees.scope.session.SessionConfigurationProvider;
import com.google.code.rees.scope.session.SessionManager;
import com.google.code.rees.scope.struts2.StrutsSessionAdapter;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionInterceptor
implements Interceptor {
    private static final long serialVersionUID = 3222190171260674636L;
    private static final Logger LOG = LoggerFactory.getLogger(SessionInterceptor.class);
    protected SessionManager sessionManager;
    protected SessionConfigurationProvider sessionConfigurationProvider;
    protected ActionProvider finder;

    @Inject(value="struts.scope.actionFinder")
    public void setActionClassFinder(ActionProvider finder) {
        this.finder = finder;
    }

    @Inject(value="struts.session.sessionManager")
    public void setSessionManager(SessionManager manager) {
        this.sessionManager = manager;
    }

    @Inject(value="struts.session.configurationProvider")
    public void setSessionConfigurationProvider(SessionConfigurationProvider sessionConfigurationProvider) {
        this.sessionConfigurationProvider = sessionConfigurationProvider;
    }

    public void destroy() {
        LOG.info("Destroying the SessionInterceptor...");
    }

    public void init() {
        LOG.info("Initializing the Session Interceptor...");
        this.sessionConfigurationProvider.init(this.finder.getActionClasses());
        this.sessionManager.setConfigurationProvider(this.sessionConfigurationProvider);
        LOG.info("...Session Interceptor successfully initialized.");
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        this.sessionManager.processSessionFields(new StrutsSessionAdapter(invocation));
        return invocation.invoke();
    }
}

