/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.context;

import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.conversation.context.ConversationContextFactory;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.conversation.context.HttpConversationContextManagerProvider;
import com.google.code.rees.scope.conversation.context.HttpConversationUtil;
import com.google.code.rees.scope.conversation.context.TimeoutConversationContextManager;
import com.google.code.rees.scope.util.monitor.ScheduledExecutorTimeoutMonitor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpConversationContextManagerProvider
implements HttpConversationContextManagerProvider {
    private static final long serialVersionUID = 1500381458203865515L;
    private static Logger LOG = LoggerFactory.getLogger(DefaultHttpConversationContextManagerProvider.class);
    protected long monitoringFrequency = 300000L;
    protected int maxInstances = 20;
    protected int monitoringThreadPoolSize = 20;
    protected ConversationContextFactory conversationContextFactory;
    protected transient ScheduledExecutorService scheduler;

    @Override
    @PostConstruct
    public void init() {
        this.scheduler = Executors.newScheduledThreadPool(this.monitoringThreadPoolSize);
    }

    @Override
    public void setMonitoringThreadPoolSize(int monitoringThreadPoolSize) {
        LOG.info("Setting conversation monitoring thread-pool size:  " + monitoringThreadPoolSize + " threads.");
        this.monitoringThreadPoolSize = monitoringThreadPoolSize;
    }

    @Override
    public void setMonitoringFrequency(long monitoringFrequency) {
        double monitoringFrequencyMinutes = (double)monitoringFrequency / 60000.0;
        LOG.info("Setting conversation timeout monitoring frequency:  " + monitoringFrequency + " milliseconds.");
        LOG.info("Converted monitoring frequency:  " + String.format("%.2f", monitoringFrequencyMinutes) + " minutes.");
        this.monitoringFrequency = monitoringFrequency;
    }

    @Override
    public void setMaxInstances(int maxInstances) {
        LOG.info("Setting max number of conversation instances per conversation:  " + maxInstances + ".");
        this.maxInstances = maxInstances;
    }

    @Override
    public void setConversationContextFactory(ConversationContextFactory conversationContextFactory) {
        this.conversationContextFactory = conversationContextFactory;
    }

    @Override
    public ConversationContextManager getManager(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ConversationContextManager contextManager = HttpConversationUtil.getContextManager(session);
        if (contextManager == null) {
            contextManager = this.createContextManager(session);
        } else {
            ScheduledExecutorTimeoutMonitor monitor = (ScheduledExecutorTimeoutMonitor)HttpConversationUtil.getTimeoutMonitor(session);
            monitor.setScheduler(this.scheduler);
        }
        return contextManager;
    }

    protected ConversationContextManager createContextManager(HttpSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new ConversationContextManager for session with ID:  " + session.getId());
        }
        TimeoutConversationContextManager contextManager = new TimeoutConversationContextManager();
        contextManager.setMaxInstances(this.maxInstances);
        contextManager.setContextFactory(this.conversationContextFactory);
        ScheduledExecutorTimeoutMonitor<ConversationContext> timeoutMonitor = ScheduledExecutorTimeoutMonitor.spawnInstance(this.scheduler, this.monitoringFrequency);
        contextManager.setTimeoutMonitor(timeoutMonitor);
        HttpConversationUtil.setContextManager(session, contextManager);
        HttpConversationUtil.setTimeoutMonitor(session, timeoutMonitor);
        return contextManager;
    }
}

