/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.context;

import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.conversation.context.ConversationContextFactory;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConversationContextManager
implements ConversationContextManager {
    private static final long serialVersionUID = 3699451038473294837L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConversationContextManager.class);
    protected ConversationContextFactory contextFactory;
    protected Map<String, Map<String, ConversationContext>> conversations = Collections.synchronizedMap(new HashMap());
    protected int maxInstances = 20;
    protected long nextId = 0L;

    @Override
    public void setMaxInstances(int maxInstances) {
        this.maxInstances = maxInstances;
    }

    @Override
    public void setContextFactory(ConversationContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConversationContext createContext(String conversationName, long maxIdleTimeMillis) {
        ConversationContext context = null;
        Map<String, Map<String, ConversationContext>> map = this.conversations;
        synchronized (map) {
            Map<String, ConversationContext> conversationContexts = this.conversations.get(conversationName);
            if (conversationContexts == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new context cache for " + conversationName);
                }
                conversationContexts = Collections.synchronizedMap(new HashMap());
                this.conversations.put(conversationName, conversationContexts);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating new ConversationContext for " + conversationName);
            }
            String conversationId = this.getNextId();
            context = this.contextFactory.create(conversationName, conversationId, maxIdleTimeMillis);
            conversationContexts.put(conversationId, context);
            if (conversationContexts.size() > this.maxInstances) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cached instances of conversation " + conversationName + " exceeds limit.  Removing stale conversations.");
                }
                this.removeMostStaleConversation(conversationContexts, conversationName, context.getRemainingTime());
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConversationContext getContext(String conversationName, String conversationId) {
        ConversationContext context = null;
        Map<String, Map<String, ConversationContext>> map = this.conversations;
        synchronized (map) {
            Map<String, ConversationContext> conversationContexts = this.conversations.get(conversationName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrieving cached instance for conversation " + conversationName);
            }
            if (conversationContexts != null && (context = conversationContexts.get(conversationId)) != null) {
                context.reset();
            }
        }
        return context;
    }

    @Override
    public ConversationContext remove(String conversationName, String conversationId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarding " + conversationName + " with ID of " + conversationId);
        }
        ConversationContext context = null;
        Map<String, ConversationContext> conversationContexts = this.conversations.get(conversationName);
        if (conversationContexts != null) {
            context = conversationContexts.remove(conversationId);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        LOG.debug("Destroying ConversationContextManager and clearing conversation cache.");
        Map<String, Map<String, ConversationContext>> map = this.conversations;
        synchronized (map) {
            for (Map.Entry<String, Map<String, ConversationContext>> conversationEntry : this.conversations.entrySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clearing contexts for " + conversationEntry.getKey() + ".");
                }
                Map<String, ConversationContext> conversationContexts = conversationEntry.getValue();
                for (ConversationContext context : conversationContexts.values()) {
                    context.clear();
                }
                conversationContexts.clear();
            }
            this.conversations.clear();
        }
        LOG.debug("ConversationContextManager destroyed and conversation cache cleared.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMostStaleConversation(Map<String, ConversationContext> conversationContexts, String conversationName, long defaultDuration) {
        String mostStaleId = null;
        long leastRemainingTime = defaultDuration;
        Map<String, ConversationContext> map = conversationContexts;
        synchronized (map) {
            for (Map.Entry<String, ConversationContext> entry : conversationContexts.entrySet()) {
                long entryRemainingTime = entry.getValue().getRemainingTime();
                if (entryRemainingTime > leastRemainingTime) continue;
                mostStaleId = entry.getKey();
                leastRemainingTime = entryRemainingTime;
            }
            this.remove(conversationName, mostStaleId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarding most stale " + conversationName + " context with ID " + mostStaleId);
            LOG.debug("Remaining " + conversationName + " contexts for this session:  " + conversationContexts.size());
        }
        if (conversationContexts.size() > this.maxInstances) {
            this.removeMostStaleConversation(conversationContexts, conversationName, defaultDuration);
        }
    }

    protected synchronized String getNextId() {
        return String.valueOf(this.nextId++);
    }
}

