/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.proxy4j.core.struct.WeakHashSet;
import org.proxy4j.core.util.Key;

public final class MethodHashKey
extends Key {
    private final Set<Method> methods = new WeakHashSet<Method>();
    private final int hash;

    public MethodHashKey(ClassLoader loader, Method[] methods) {
        this(loader, Arrays.asList(methods));
    }

    public MethodHashKey(ClassLoader loader, Collection<Method> methods) {
        super(loader);
        this.methods.addAll(methods);
        this.hash = this.internalHash();
    }

    private int internalHash() {
        int result = 17;
        if (this.getClassLoader() != null) {
            result = 37 * result + this.getClassLoader().hashCode();
        }
        result = 37 * result + this.methods.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodHashKey that = (MethodHashKey)o;
        return this.getClassLoader() != null && this.getClassLoader().equals(that.getClassLoader()) && this.methods.equals(that.methods);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }
}

