/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.struct;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class WeakArrayList<T>
extends AbstractList<T> {
    private List<WeakReference<T>> internalList = new ArrayList<WeakReference<T>>();

    @Override
    public void add(int index, T element) {
        this.internalList.add(index, new WeakReference<T>(element));
    }

    @Override
    public boolean add(T o) {
        return this.internalList.add(new WeakReference<T>(o));
    }

    @Override
    public T get(int index) {
        WeakReference<T> element = this.internalList.get(index);
        return element == null ? null : (T)element.get();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean added = true;
        for (T element : c) {
            added &= this.add(element);
        }
        return added;
    }

    @Override
    public int size() {
        return this.internalList.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<WeakReference<T>> internal;
            {
                this.internal = WeakArrayList.this.internalList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.internal.hasNext();
            }

            @Override
            public T next() {
                WeakReference n = this.internal.next();
                return n == null ? null : (Object)n.get();
            }

            @Override
            public void remove() {
                this.internal.remove();
            }
        };
    }
}

