/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.struct;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

public class IdentityHashSet<T>
extends AbstractSet<T>
implements Set<T> {
    private final IdentityHashMap<T, Object> idmap;
    private static final Object NULL_OBJ = new Object();

    public IdentityHashSet() {
        this.idmap = new IdentityHashMap();
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.idmap = new IdentityHashMap(expectedMaxSize);
    }

    public IdentityHashSet(Collection<? extends T> c) {
        this(c.size());
        this.addAll(c);
    }

    @Override
    public boolean add(T o) {
        return this.idmap.put(o, NULL_OBJ) == null;
    }

    @Override
    public void clear() {
        this.idmap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.idmap.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.idmap.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.idmap.remove(o) == NULL_OBJ;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.idmap.keySet().removeAll(c);
    }

    @Override
    public int size() {
        return this.idmap.size();
    }
}

