/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

public class SignatureKey
implements Comparable<SignatureKey> {
    private String name;
    private Class<?>[] parameterTypes;

    public SignatureKey(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public SignatureKey(String name, Class<?> ... parameterTypes) {
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public static Comparator<Method> methodComparator() {
        return new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return new SignatureKey(m1).compareTo(new SignatureKey(m2));
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureKey signatureKey = (SignatureKey)o;
        return this.name.equals(signatureKey.name) && Arrays.equals(this.parameterTypes, signatureKey.parameterTypes);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    @Override
    public int compareTo(SignatureKey other) {
        int comparison = this.name.compareTo(other.name);
        if (comparison == 0 && (comparison = new Integer(this.parameterTypes.length).compareTo(other.parameterTypes.length)) == 0) {
            for (int i = 0; i < this.parameterTypes.length && (comparison = this.parameterTypes[i].getName().compareTo(other.parameterTypes[i].getName())) == 0; ++i) {
            }
        }
        return comparison;
    }
}

