/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.proxy4j.core.filter.MethodFilter;
import org.proxy4j.core.reflect.Modifier;
import org.proxy4j.core.reflect.SignatureKey;
import org.proxy4j.core.reflect.UnitypeMethodExtractor;
import org.proxy4j.core.reflect.Visibility;

public class InheritableMethodExtractor
extends UnitypeMethodExtractor {
    private Class<?> superType;
    private Map<Method, Method> methodPairMap;

    public <T> InheritableMethodExtractor(Class<T> owningType, Class<? super T> superType) {
        super(owningType);
        this.superType = superType;
        this.methodPairMap = new TreeMap<Method, Method>(SignatureKey.methodComparator());
        this.buildMethodMap();
    }

    private void buildMethodMap() {
        HashMap<SignatureKey, Method> superTypeMap = new HashMap<SignatureKey, Method>();
        for (Method m : this.superType.getMethods()) {
            superTypeMap.put(new SignatureKey(m), m);
        }
        for (Class<?> current = this.getOwningType(); current != null && (this.isIncludeObjectMethods() || !current.getName().equals("java.lang.Object")); current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (this.methodPairMap.containsKey(m)) continue;
                SignatureKey s = new SignatureKey(m);
                this.methodPairMap.put(m, (Method)superTypeMap.get(s));
            }
        }
    }

    @Override
    public Collection<Method> getProxyableMethods() {
        return this.methodPairMap.keySet();
    }

    @Override
    public Collection<Method> getPublicMethods() {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        for (Method m : this.methodPairMap.keySet()) {
            if (Visibility.getVisibility(m) != Visibility.PUBLIC) continue;
            publicMethods.add(m);
        }
        return publicMethods;
    }

    @Override
    public Collection<Method> getMethods(MethodFilter filter) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : this.methodPairMap.keySet()) {
            Method other;
            if (!filter.accept(m) && ((other = this.methodPairMap.get(m)) == null || !filter.accept(other))) continue;
            methods.add(m);
        }
        return methods;
    }

    @Override
    protected boolean isObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("java.lang.Object");
    }

    @Override
    protected boolean isProxyable(Method method) {
        Visibility methodVisibility = Visibility.getVisibility(method);
        EnumSet<Modifier> modifiers = Modifier.getModifiers(method);
        if (methodVisibility == Visibility.PRIVATE || modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC)) {
            return false;
        }
        return methodVisibility == Visibility.PUBLIC || methodVisibility == Visibility.PROTECTED || this.getPackageName(method.getDeclaringClass()).equals(this.getOwningPackageName());
    }
}

