/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.jdk;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import javax.inject.Provider;
import org.proxy4j.core.BaseProxyFactory;
import org.proxy4j.core.GenerationException;
import org.proxy4j.core.ProxyHandler;
import org.proxy4j.core.ProxyLoader;
import org.proxy4j.core.build.InterceptorBuilder;
import org.proxy4j.core.jdk.JdkInterceptorBuilder;
import org.proxy4j.core.jdk.JdkProxyInvocation;

public class JdkProxyFactory
extends BaseProxyFactory {
    public JdkProxyFactory() {
    }

    @Inject
    public JdkProxyFactory(@ProxyLoader ClassLoader loader) {
        super(loader);
    }

    @Override
    public <T> T createProxy(Class<T> proxyInterface, final Provider<T> provider) throws GenerationException {
        return proxyInterface.cast(Proxy.newProxyInstance(this.getProxyClassLoader(proxyInterface), new Class[]{proxyInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke(provider.get(), args);
            }
        }));
    }

    @Override
    public <T> T createProxy(Class<T> proxyInterface, final ProxyHandler<T> handler) throws GenerationException {
        return proxyInterface.cast(Proxy.newProxyInstance(this.getProxyClassLoader(proxyInterface), new Class[]{proxyInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return handler.handle(new JdkProxyInvocation<Object>(proxy, method, args));
            }
        }));
    }

    @Override
    public Object createProxy(Class<?>[] proxyInterfaces, final ProxyHandler<?> handler) throws GenerationException {
        if (proxyInterfaces.length == 0) {
            throw new IllegalArgumentException("Must define at least 1 proxy interface");
        }
        return Proxy.newProxyInstance(this.getProxyClassLoader(proxyInterfaces[0]), proxyInterfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return handler.handle(new JdkProxyInvocation<Object>(proxy, method, args));
            }
        });
    }

    @Override
    public <T> InterceptorBuilder<T> buildInterceptor(Class<T> proxyClass) {
        return new JdkInterceptorBuilder<T>(this.getProxyClassLoader(proxyClass), proxyClass);
    }
}

