/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.javassist;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.proxy4j.core.GenerationException;
import org.proxy4j.core.InterceptorChain;
import org.proxy4j.core.InterceptorFactory;
import org.proxy4j.core.build.InterceptorBindingBuilder;
import org.proxy4j.core.build.InterceptorBuilder;
import org.proxy4j.core.build.InterceptorCreator;
import org.proxy4j.core.build.MethodBindingBuilder;
import org.proxy4j.core.filter.AnnotationFilter;
import org.proxy4j.core.filter.MethodFilter;
import org.proxy4j.core.javassist.ClassGenerator;
import org.proxy4j.core.reflect.BasicMethodExtractor;
import org.proxy4j.core.reflect.MethodExtractor;

public class JavassistInterceptorBuilder<T>
implements InterceptorBuilder<T> {
    private ClassLoader loader;
    private MethodExtractor extractor;
    private ClassGenerator generator;
    private T target;

    JavassistInterceptorBuilder(ClassLoader loader, Class<T> proxyInterface, ClassGenerator generator) {
        this.loader = loader;
        this.generator = generator;
    }

    @Override
    public InterceptorBindingBuilder<T> on(T target) {
        this.target = target;
        this.extractor = new BasicMethodExtractor(target.getClass());
        return new JavassistInterceptorBindingBuilder();
    }

    private class JavassistInterceptorCreator
    implements InterceptorCreator<T> {
        private Map<Method, InterceptorChain> methodMap;

        JavassistInterceptorCreator(Map<Method, InterceptorChain> methodMap) {
            this.methodMap = methodMap;
        }

        @Override
        public T create() throws GenerationException {
            try {
                Class proxyClass = JavassistInterceptorBuilder.this.generator.getInterceptorProxyClass(JavassistInterceptorBuilder.this.loader, JavassistInterceptorBuilder.this.target, this.methodMap);
                InterceptorChain[] chains = this.methodMap.values().toArray(new InterceptorChain[this.methodMap.size()]);
                return proxyClass.getConstructor(JavassistInterceptorBuilder.this.target.getClass(), chains.getClass()).newInstance(JavassistInterceptorBuilder.this.target, chains);
            }
            catch (Exception e) {
                throw new GenerationException("Unable to generator interceptor proxy", e);
            }
        }
    }

    private class JavassistMethodBindingBuilder
    extends AbstractBindingBuilder
    implements MethodBindingBuilder<T> {
        JavassistMethodBindingBuilder(Map<Method, InterceptorChain> methodMap) {
            super(methodMap);
        }

        @Override
        public MethodBindingBuilder<T> using(Method method, MethodInterceptor ... interceptors) {
            this.bind(method, new InterceptorChain(interceptors));
            return this;
        }

        @Override
        public T create() throws GenerationException {
            return new JavassistInterceptorCreator(this.getMethodMap()).create();
        }
    }

    private class JavassistInterceptorBindingBuilder
    extends AbstractBindingBuilder
    implements InterceptorBindingBuilder<T> {
        private JavassistInterceptorBindingBuilder() {
        }

        @Override
        public InterceptorCreator<T> using(MethodFilter filter, MethodInterceptor ... interceptors) {
            for (Method m : JavassistInterceptorBuilder.this.extractor.getMethods(filter)) {
                this.bind(m, new InterceptorChain(interceptors));
            }
            return new JavassistInterceptorCreator(this.getMethodMap());
        }

        @Override
        public InterceptorCreator<T> using(MethodFilter filter, InterceptorFactory factory) {
            for (Method m : JavassistInterceptorBuilder.this.extractor.getMethods(filter)) {
                this.bind(m, new InterceptorChain(factory.getInterceptors(m)));
            }
            return new JavassistInterceptorCreator(this.getMethodMap());
        }

        @Override
        public InterceptorCreator<T> using(Class<? extends Annotation> methodMarker, MethodInterceptor ... interceptors) {
            for (Method m : JavassistInterceptorBuilder.this.extractor.getMethods(AnnotationFilter.forAnnotation(methodMarker))) {
                this.bind(m, new InterceptorChain(interceptors));
            }
            return new JavassistInterceptorCreator(this.getMethodMap());
        }

        @Override
        public MethodBindingBuilder<T> using(Method method, MethodInterceptor ... interceptors) {
            this.bind(method, new InterceptorChain(interceptors));
            return new JavassistMethodBindingBuilder(this.getMethodMap());
        }
    }

    private static class AbstractBindingBuilder {
        private Map<Method, InterceptorChain> methodMap;

        AbstractBindingBuilder() {
            this.methodMap = new LinkedHashMap<Method, InterceptorChain>();
        }

        AbstractBindingBuilder(Map<Method, InterceptorChain> methodMap) {
            this.methodMap = methodMap;
        }

        void bind(Method method, InterceptorChain chain) {
            if (this.methodMap.containsKey(method)) {
                throw new IllegalArgumentException("Method already bound to interceptor: " + method.getName());
            }
            this.methodMap.put(method, chain);
        }

        protected Map<Method, InterceptorChain> getMethodMap() {
            return this.methodMap;
        }
    }
}

