/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.javassist;

import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javax.inject.Provider;
import org.aopalliance.intercept.MethodInvocation;
import org.proxy4j.core.InterceptorChain;
import org.proxy4j.core.ProxyHandler;
import org.proxy4j.core.ProxyInvocation;
import org.proxy4j.core.javassist.JavassistMethodInvocation;
import org.proxy4j.core.javassist.JavassistProxyInvocation;
import org.proxy4j.core.reflect.BasicMethodExtractor;
import org.proxy4j.core.reflect.MethodExtractor;
import org.proxy4j.core.reflect.MultitypeMethodExtractor;
import org.proxy4j.core.util.ClassCache;
import org.proxy4j.core.util.ClassHashKey;
import org.proxy4j.core.util.MethodHashKey;
import org.proxy4j.core.util.NamingPolicy;

class ClassGenerator {
    private NamingPolicy namingPolicy;
    private ClassCache cache = new ClassCache();
    Properties templates = new Properties();
    private final Map<ClassLoader, ClassPool> classPoolMap = new WeakHashMap<ClassLoader, ClassPool>();

    ClassGenerator(NamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
        try {
            this.templates.load(this.getClass().getResourceAsStream("/template.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load Javassist template properties", e);
        }
    }

    <T> Class<T> getProviderProxyClass(ClassLoader loader, Class<T> proxyType) throws NotFoundException, CannotCompileException {
        ClassHashKey key = new ClassHashKey(loader, Provider.class, proxyType);
        Class cl = this.cache.getClass(key);
        if (cl != null) {
            return cl;
        }
        ClassPool pool = this.getClassPool(loader);
        CtClass newCtClass = this.getSkeleton(pool, this.namingPolicy.getProxyName(proxyType.getName(), key), proxyType, new Class[0]);
        CtClass providerCtClass = this.fetch(pool, Provider.class);
        this.addField(newCtClass, "provider", providerCtClass);
        this.addConstructor(newCtClass, "{this.provider = $1;}", providerCtClass);
        BasicMethodExtractor extractor = new BasicMethodExtractor(proxyType);
        for (Method m : extractor.getProxyableMethods()) {
            String body = this.getDelegateBody("((" + proxyType.getName() + ")provider.get())", m);
            this.addMethod(pool, newCtClass, m, body);
        }
        cl = newCtClass.toClass(loader, null);
        this.cache.cache(key, cl);
        return cl;
    }

    <T> Class<T> getHandlerProxyClass(ClassLoader loader, Class<T> proxyType) throws NotFoundException, CannotCompileException {
        ClassHashKey key = new ClassHashKey(loader, ProxyHandler.class, proxyType);
        Class cl = this.cache.getClass(key);
        if (cl != null) {
            return cl;
        }
        ClassPool pool = this.getClassPool(loader);
        BasicMethodExtractor extractor = new BasicMethodExtractor(proxyType);
        Collection<Method> proxyableMethods = extractor.getProxyableMethods();
        CtClass newCtClass = this.getSkeleton(pool, this.namingPolicy.getProxyName(proxyType.getName(), key), proxyType, new Class[0]);
        this.createMethod(pool, newCtClass, new MethodSignature(Method[].class, "getProxyableMethods", new Class[0]), "return ($r) new " + extractor.getClass().getName() + "(" + proxyType.getName() + ".class" + ").getProxyableMethods().toArray(new java.lang.reflect.Method[" + proxyableMethods.size() + "]);", 10);
        this.addStaticField(newCtClass, "methods", this.fetch(pool, Method[].class), CtField.Initializer.byCall((CtClass)newCtClass, (String)"getProxyableMethods"));
        this.createHandlers(pool, extractor, newCtClass);
        cl = newCtClass.toClass(loader, null);
        this.cache.cache(key, cl);
        return cl;
    }

    Class<?> getHandlerProxyClass(ClassLoader loader, Class<?>[] proxyInterfaces) throws NotFoundException, CannotCompileException {
        ClassHashKey key = new ClassHashKey(loader, proxyInterfaces);
        Class cl = this.cache.getClass(key);
        if (cl != null) {
            return cl;
        }
        ClassPool pool = this.getClassPool(loader);
        CtClass newCtClass = this.getSkeleton(pool, this.namingPolicy.getProxyName("", key), Object.class, proxyInterfaces);
        MultitypeMethodExtractor extractor = new MultitypeMethodExtractor(proxyInterfaces);
        Collection<Method> proxyableMethods = extractor.getProxyableMethods();
        this.createMethod(pool, newCtClass, new MethodSignature(Method[].class, "getProxyableMethods", new Class[0]), "return ($r) new " + extractor.getClass().getName() + "(new Class[]{" + this.classListAsString(proxyInterfaces) + "}).getProxyableMethods().toArray(new java.lang.reflect.Method[" + proxyableMethods.size() + "]);", 10);
        this.addStaticField(newCtClass, "methods", this.fetch(pool, Method[].class), CtField.Initializer.byCall((CtClass)newCtClass, (String)"getProxyableMethods"));
        this.createHandlers(pool, extractor, newCtClass);
        cl = newCtClass.toClass(loader, null);
        this.cache.cache(key, cl);
        return cl;
    }

    private void createHandlers(ClassPool pool, MethodExtractor extractor, CtClass newCtClass) throws CannotCompileException, NotFoundException {
        CtClass invocationHandlerClass = this.fetch(pool, ProxyHandler.class);
        this.addField(newCtClass, "handler", invocationHandlerClass);
        this.addConstructor(newCtClass, "{this.handler = $1;}", invocationHandlerClass);
        Iterator<Method> methodIter = extractor.getProxyableMethods().iterator();
        int i = 0;
        while (methodIter.hasNext()) {
            Method m = methodIter.next();
            StringBuilder body = new StringBuilder(ProxyInvocation.class.getName()).append(" i = new ").append(JavassistProxyInvocation.class.getName()).append("(this, methods[").append(i).append("], $args);").append("return ($r) handler.handle(i);");
            this.addMethod(pool, newCtClass, m, this.wrapBody(body));
            ++i;
        }
    }

    <T> Class<T> getInterceptorProxyClass(ClassLoader loader, T target, Map<Method, InterceptorChain> methodMap) throws NotFoundException, CannotCompileException {
        MethodHashKey key = new MethodHashKey(loader, methodMap.keySet());
        Class cl = this.cache.getClass(key);
        if (cl != null) {
            return cl;
        }
        String className = this.namingPolicy.getProxyName(target.getClass().getName(), key);
        ClassPool pool = this.getClassPool(loader);
        CtClass newCtClass = this.getSkeleton(pool, className, target.getClass(), new Class[0]);
        CtClass targetCtClass = this.fetch(pool, target.getClass());
        CtClass chainArrayCtClass = this.fetch(pool, InterceptorChain[].class);
        this.addField(newCtClass, "target", targetCtClass);
        this.addField(newCtClass, "chains", chainArrayCtClass);
        this.addConstructor(newCtClass, "{this.target = $1; this.chains = $2;}", targetCtClass, chainArrayCtClass);
        BasicMethodExtractor extractor = new BasicMethodExtractor(target.getClass());
        for (Method m : extractor.getProxyableMethods()) {
            if (methodMap.containsKey(m)) continue;
            this.addMethod(pool, newCtClass, m, this.getDelegateBody("target", m));
        }
        Method[] proxiedMethods = methodMap.keySet().toArray(new Method[methodMap.size()]);
        for (int i = 0; i < proxiedMethods.length; ++i) {
            CtClass invocationClass = this.getMethodInvocationClass(pool, target.getClass(), className, i, proxiedMethods[i]);
            invocationClass.toClass(loader, null);
            String body = MethodInvocation.class.getName() + " i = new " + invocationClass.getName() + "(target,\"" + proxiedMethods[i].getName() + "\", $args);" + "return ($r) chains[" + i + "].invoke(i);";
            this.addMethod(pool, newCtClass, proxiedMethods[i], this.wrapBody(body));
        }
        cl = newCtClass.toClass(loader, null);
        this.cache.cache(key, cl);
        return cl;
    }

    CtClass getSkeleton(ClassPool pool, String name, Class<?> superClass, Class<?> ... interfaces) throws CannotCompileException, NotFoundException {
        CtClass ctClass = pool.makeClass(name);
        if (!superClass.isInterface()) {
            ctClass.setSuperclass(this.fetch(pool, superClass));
        } else {
            ctClass.addInterface(this.fetch(pool, superClass));
        }
        for (Class<?> iface : interfaces) {
            ctClass.addInterface(this.fetch(pool, iface));
        }
        return ctClass;
    }

    CtClass fetch(ClassPool pool, Class<?> type) throws NotFoundException {
        return pool.get(type.getName());
    }

    CtClass[] fetch(ClassPool pool, Class<?>[] types) throws NotFoundException {
        CtClass[] resolvedClasses = new CtClass[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedClasses[i] = pool.get(types[i].getName());
        }
        return resolvedClasses;
    }

    private void addConstructor(CtClass owner, String body, CtClass ... args) throws CannotCompileException {
        CtConstructor proxyConstructor = new CtConstructor(args, owner);
        owner.addConstructor(proxyConstructor);
        proxyConstructor.setBody(body);
    }

    private void addField(CtClass owner, String name, CtClass fieldType) throws CannotCompileException {
        CtField field = new CtField(fieldType, name, owner);
        field.setModifiers(2);
        owner.addField(field);
    }

    private void addStaticField(CtClass owner, String name, CtClass fieldType, CtField.Initializer init) throws CannotCompileException {
        CtField field = new CtField(fieldType, name, owner);
        field.setModifiers(10);
        owner.addField(field, init);
    }

    private void addMethod(ClassPool pool, CtClass owningClass, Method m, String body) throws CannotCompileException, NotFoundException {
        CtMethod method = CtNewMethod.make((CtClass)this.fetch(pool, m.getReturnType()), (String)m.getName(), (CtClass[])this.fetch(pool, m.getParameterTypes()), (CtClass[])this.fetch(pool, m.getExceptionTypes()), (String)body, (CtClass)owningClass);
        method.setModifiers(m.getModifiers() & 0xFFFFFBFF);
        owningClass.addMethod(method);
    }

    private void createMethod(ClassPool pool, CtClass owningClass, MethodSignature signature, String body, int modifiers) throws NotFoundException, CannotCompileException {
        CtMethod method = CtNewMethod.make((CtClass)this.fetch(pool, signature.getReturnType()), (String)signature.getName(), (CtClass[])this.fetch(pool, signature.getParameterTypes()), (CtClass[])this.fetch(pool, signature.getExceptionTypes()), (String)body, (CtClass)owningClass);
        method.setModifiers(modifiers);
        owningClass.addMethod(method);
    }

    private String getDelegateBody(String delegateExpr, Method m) {
        String template = m.getReturnType().equals(Void.TYPE) ? this.templates.getProperty("delegate.method.body.noreturn") : this.templates.getProperty("delegate.method.body.return");
        return this.wrapBody(MessageFormat.format(template, delegateExpr, m.getName(), "$$"));
    }

    private CtClass getMethodInvocationClass(ClassPool pool, Class<?> targetClass, String proxyClassName, int index, Method m) throws NotFoundException, CannotCompileException {
        Method proceedMethod;
        CtClass invocationClass = this.getSkeleton(pool, proxyClassName + "$$" + index, JavassistMethodInvocation.class, new Class[0]);
        try {
            proceedMethod = JavassistMethodInvocation.class.getMethod("proceed", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to get proceed() method", e);
        }
        String template = m.getReturnType().equals(Void.TYPE) ? this.templates.getProperty("interceptor.proceed.body.noreturn") : (m.getReturnType().isPrimitive() ? this.templates.getProperty("interceptor.proceed.body.return.boxed") : this.templates.getProperty("interceptor.proceed.body.return"));
        this.addConstructor(invocationClass, "{ super($$); }", this.fetch(pool, Object.class), this.fetch(pool, String.class), this.fetch(pool, Object[].class));
        String body = !m.getReturnType().equals(Void.TYPE) && m.getReturnType().isPrimitive() ? MessageFormat.format(template, this.getBoxedType(m.getReturnType()), "((" + targetClass.getName() + ") getThis())", m.getName(), "$$") : MessageFormat.format(template, "((" + targetClass.getName() + ") getThis())", m.getName(), "$$");
        this.addMethod(pool, invocationClass, proceedMethod, this.wrapBody(body));
        return invocationClass;
    }

    private String getBoxedType(Class<?> primitiveType) {
        if (primitiveType.equals(Integer.TYPE)) {
            return "Integer";
        }
        if (primitiveType.equals(Long.TYPE)) {
            return "Long";
        }
        if (primitiveType.equals(Float.TYPE)) {
            return "Float";
        }
        if (primitiveType.equals(Double.TYPE)) {
            return "Double";
        }
        return "Character";
    }

    private String wrapBody(CharSequence body) {
        return "{" + body + '}';
    }

    private String classListAsString(Class<?> ... classes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < classes.length; ++i) {
            sb.append(classes[i].getName()).append(".class");
            if (i >= classes.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassPool getClassPool(ClassLoader classLoader) {
        Map<ClassLoader, ClassPool> map = this.classPoolMap;
        synchronized (map) {
            ClassPool cpool = this.classPoolMap.get(classLoader);
            if (cpool == null) {
                cpool = new ClassPool();
                cpool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
                this.classPoolMap.put(classLoader, cpool);
            }
            return cpool;
        }
    }

    private static class MethodSignature {
        private String name;
        private Class<?> returnType;
        private Class<?>[] parameterTypes;
        private Class<?>[] exceptionTypes;

        MethodSignature(Class<?> returnType, String name, Class<?> ... parameterTypes) {
            this.returnType = returnType;
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        MethodSignature(Method method) {
            this(method.getReturnType(), method.getName(), method.getParameterTypes());
            this.setExceptionTypes(method.getExceptionTypes());
        }

        void setExceptionTypes(Class<?> ... exceptionTypes) {
            this.exceptionTypes = exceptionTypes;
        }

        String getName() {
            return this.name;
        }

        Class<?> getReturnType() {
            return this.returnType;
        }

        Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        Class<?>[] getExceptionTypes() {
            return this.exceptionTypes == null ? new Class[]{} : this.exceptionTypes;
        }
    }
}

