/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.cglib;

import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;

abstract class ClassGenerator<T> {
    ClassGenerator() {
    }

    static <T> ClassGenerator<T> forType(ClassLoader loader, Class<T> type) {
        return new SingleTypeGenerator<T>(loader, type);
    }

    static ClassGenerator<?> forTypes(ClassLoader loader, Class<?> ... interfaces) {
        return new MultiTypeGenerator(loader, interfaces);
    }

    static <T> ClassGenerator<T> forTypes(ClassLoader loader, Class<T> superType, Class<?> ... interfaces) {
        return new MultiTypeGenerator<T>(loader, superType, interfaces);
    }

    abstract Class<T> generate(Class<? extends Callback> var1);

    abstract Class<T> generate(CallbackFilter var1, Class<? extends Callback> ... var2);

    protected Enhancer newEnhancer(ClassLoader loader, Class<?> type, Class<?>[] interfaces) {
        Enhancer enhancer = this.newEnhancer(loader, type);
        enhancer.setInterfaces((Class[])interfaces);
        return enhancer;
    }

    protected Enhancer newEnhancer(ClassLoader loader, Class<?> type) {
        Enhancer enhancer = new Enhancer();
        enhancer.setUseFactory(false);
        enhancer.setClassLoader(loader);
        enhancer.setSuperclass(type);
        return enhancer;
    }

    static class MultiTypeGenerator<T>
    extends ClassGenerator<T> {
        private ClassLoader loader;
        private Class<T> superType;
        private Class<?>[] proxyInterfaces;

        private MultiTypeGenerator(ClassLoader loader, Class<?>[] proxyInterfaces) {
            this.loader = loader;
            this.proxyInterfaces = proxyInterfaces;
        }

        private MultiTypeGenerator(ClassLoader loader, Class<T> superType, Class<?>[] proxyInterfaces) {
            this.loader = loader;
            this.proxyInterfaces = proxyInterfaces;
            this.superType = superType;
        }

        @Override
        Class<T> generate(Class<? extends Callback> callbackClass) {
            Enhancer enhancer = this.newEnhancer(this.loader, this.superType, this.proxyInterfaces);
            enhancer.setCallbackType(callbackClass);
            return enhancer.createClass();
        }

        @Override
        Class<T> generate(CallbackFilter filter, Class<? extends Callback> ... callbackClasses) {
            Enhancer enhancer = this.newEnhancer(this.loader, this.superType, this.proxyInterfaces);
            enhancer.setCallbackTypes((Class[])callbackClasses);
            enhancer.setCallbackFilter(filter);
            return enhancer.createClass();
        }
    }

    static class SingleTypeGenerator<T>
    extends ClassGenerator<T> {
        private ClassLoader loader;
        private Class<T> proxyClass;

        private SingleTypeGenerator(ClassLoader loader, Class<T> proxyClass) {
            this.loader = loader;
            this.proxyClass = proxyClass;
        }

        @Override
        Class<T> generate(Class<? extends Callback> callbackClass) {
            Enhancer enhancer = this.newEnhancer(this.loader, this.proxyClass);
            enhancer.setCallbackType(callbackClass);
            return enhancer.createClass();
        }

        @Override
        Class<T> generate(CallbackFilter filter, Class<? extends Callback> ... callbackClasses) {
            Enhancer enhancer = this.newEnhancer(this.loader, this.proxyClass);
            enhancer.setCallbackTypes((Class[])callbackClasses);
            enhancer.setCallbackFilter(filter);
            return enhancer.createClass();
        }
    }
}

