/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.cglib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Provider;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import org.proxy4j.core.BaseProxyFactory;
import org.proxy4j.core.GenerationException;
import org.proxy4j.core.ProxyHandler;
import org.proxy4j.core.ProxyLoader;
import org.proxy4j.core.build.InterceptorBuilder;
import org.proxy4j.core.cglib.CglibInterceptorBuilder;
import org.proxy4j.core.cglib.CglibProxyInvocation;
import org.proxy4j.core.cglib.ClassGenerator;

public class CglibProxyFactory
extends BaseProxyFactory {
    public CglibProxyFactory() {
    }

    @Inject
    public CglibProxyFactory(@ProxyLoader ClassLoader loader) {
        super(loader);
    }

    @Override
    public <T> T createProxy(Class<T> proxyClass, Provider<T> provider) throws GenerationException {
        FastClass fastClass = this.getProxyClass(this.getProxyClassLoader(proxyClass), proxyClass, (Callback)new ProviderAdapter(provider));
        try {
            T t = proxyClass.cast(fastClass.newInstance());
            return t;
        }
        catch (InvocationTargetException ite) {
            throw new GenerationException("Error creating Provider proxy", ite);
        }
        finally {
            this.clean(fastClass);
        }
    }

    @Override
    public <T> T createProxy(Class<T> proxyClass, ProxyHandler<T> handler) throws GenerationException {
        FastClass fastClass = this.getProxyClass(this.getProxyClassLoader(proxyClass), proxyClass, (Callback)new InvocationHandlerAdapter(handler));
        try {
            T t = proxyClass.cast(fastClass.newInstance());
            return t;
        }
        catch (InvocationTargetException ite) {
            throw new GenerationException("Error creating Invocation proxy", ite);
        }
        finally {
            this.clean(fastClass);
        }
    }

    @Override
    public Object createProxy(Class<?>[] proxyInterfaces, ProxyHandler<?> handler) throws GenerationException {
        if (proxyInterfaces.length == 0) {
            throw new IllegalArgumentException("Must be at least 1 proxy interface class");
        }
        this.assertInterfaces(proxyInterfaces);
        FastClass fastClass = this.getProxyClass(this.getProxyClassLoader(proxyInterfaces[0]), proxyInterfaces, (Callback)new InvocationHandlerAdapter(handler));
        try {
            Object object = fastClass.newInstance();
            return object;
        }
        catch (InvocationTargetException ite) {
            throw new GenerationException("Error creating Invocation proxy", ite);
        }
        finally {
            this.clean(fastClass);
        }
    }

    @Override
    public <T> InterceptorBuilder<T> buildInterceptor(Class<T> proxyClass) {
        return new CglibInterceptorBuilder(this.getProxyClassLoader(proxyClass));
    }

    private FastClass getProxyClass(ClassLoader loader, Class<?> proxyClass, Callback callback) {
        FastClass fastClass = null;
        if (fastClass == null) {
            Class<?> enhanced = ClassGenerator.forType(loader, proxyClass).generate(callback.getClass());
            fastClass = FastClass.create(enhanced);
        }
        Enhancer.registerCallbacks((Class)fastClass.getJavaClass(), (Callback[])new Callback[]{callback});
        return fastClass;
    }

    private FastClass getProxyClass(ClassLoader loader, Class<?>[] interfaces, Callback callback) {
        FastClass fastClass = null;
        if (fastClass == null) {
            Class<?> enhanced = ClassGenerator.forTypes(loader, interfaces).generate(callback.getClass());
            fastClass = FastClass.create(enhanced);
        }
        Enhancer.registerCallbacks((Class)fastClass.getJavaClass(), (Callback[])new Callback[]{callback});
        return fastClass;
    }

    private void clean(FastClass fastClass) {
        Enhancer.registerCallbacks((Class)fastClass.getJavaClass(), null);
    }

    private static class InvocationHandlerAdapter
    implements MethodInterceptor {
        private ProxyHandler<?> handler;

        InvocationHandlerAdapter(ProxyHandler<?> handler) {
            this.handler = handler;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return this.handler.handle(new CglibProxyInvocation<Object>(proxy, method, methodProxy, args));
        }
    }

    private static class ProviderAdapter
    implements Dispatcher {
        private Provider<?> provider;

        ProviderAdapter(Provider<?> provider) {
            this.provider = provider;
        }

        public Object loadObject() throws Exception {
            return this.provider.get();
        }
    }
}

