/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.cglib;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.aopalliance.intercept.MethodInvocation;
import org.proxy4j.core.GenerationException;
import org.proxy4j.core.InterceptorChain;
import org.proxy4j.core.InterceptorFactory;
import org.proxy4j.core.build.InterceptorBindingBuilder;
import org.proxy4j.core.build.InterceptorBuilder;
import org.proxy4j.core.build.InterceptorCreator;
import org.proxy4j.core.build.MethodBinder;
import org.proxy4j.core.build.MethodBindingBuilder;
import org.proxy4j.core.cglib.CallbackMapper;
import org.proxy4j.core.cglib.CglibMethodInvocation;
import org.proxy4j.core.cglib.ProxyCreator;
import org.proxy4j.core.filter.AnnotationFilter;
import org.proxy4j.core.filter.MethodFilter;

class CglibInterceptorBuilder<T>
implements InterceptorBuilder<T> {
    private ClassLoader loader;
    private ProxyCreator<T> proxyCreator;
    private T target;

    CglibInterceptorBuilder(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public InterceptorBindingBuilder<T> on(T target) {
        this.target = target;
        this.proxyCreator = new ProxyCreator(this.loader, target.getClass());
        return new CglibInterceptorBindingBuilder();
    }

    private Callback getCallback(org.aopalliance.intercept.MethodInterceptor ... interceptors) {
        return interceptors.length == 1 ? new InterceptorCallback(this.target, interceptors[0]) : new InterceptorChainCallback(this.target, interceptors);
    }

    private Callback getCallback(List<org.aopalliance.intercept.MethodInterceptor> interceptors) {
        return interceptors.size() == 1 ? new InterceptorCallback(this.target, interceptors.get(0)) : new InterceptorChainCallback(interceptors);
    }

    private static class InterceptorCallback
    implements MethodInterceptor {
        private org.aopalliance.intercept.MethodInterceptor interceptor;
        private Object target;

        InterceptorCallback(Object target, org.aopalliance.intercept.MethodInterceptor interceptor) {
            this.target = target;
            this.interceptor = interceptor;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return this.interceptor.invoke((MethodInvocation)new CglibMethodInvocation(this.target, method, methodProxy, args));
        }
    }

    private static class InterceptorChainCallback
    implements MethodInterceptor {
        private InterceptorChain chain;
        private Object target;

        InterceptorChainCallback(Object target, org.aopalliance.intercept.MethodInterceptor ... interceptors) {
            this.target = target;
            this.chain = new InterceptorChain(interceptors);
        }

        InterceptorChainCallback(List<org.aopalliance.intercept.MethodInterceptor> interceptors) {
            this.chain = new InterceptorChain(interceptors);
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return this.chain.invoke(new CglibMethodInvocation(this.target, method, methodProxy, args));
        }
    }

    private static class BindingCallbackMapper
    implements CallbackMapper {
        private Map<Method, Callback> map = new HashMap<Method, Callback>();

        void bind(Method m, Callback callback) {
            if (this.map.containsKey(m)) {
                throw new IllegalArgumentException("Method already bound to interceptor: " + m.getName());
            }
            this.map.put(m, callback);
        }

        @Override
        public Callback map(Method method) {
            Callback callback = this.map.get(method);
            return callback != null ? callback : NoOp.INSTANCE;
        }
    }

    private class CglibInterceptorCreator
    implements InterceptorCreator<T> {
        private CallbackMapper mapper;

        CglibInterceptorCreator(CallbackMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public T create() throws GenerationException {
            return CglibInterceptorBuilder.this.proxyCreator.newProxy(this.mapper);
        }
    }

    private class CglibMethodBindingBuilder
    extends AbstractMethodBinder
    implements InterceptorCreator<T>,
    MethodBindingBuilder<T> {
        CglibMethodBindingBuilder(BindingCallbackMapper mapper) {
            super(mapper);
        }

        @Override
        public MethodBindingBuilder<T> using(Method method, org.aopalliance.intercept.MethodInterceptor ... interceptors) {
            this.map(method, interceptors);
            return this;
        }

        @Override
        public T create() throws GenerationException {
            CglibInterceptorCreator creator = new CglibInterceptorCreator(this.getMethodMapper());
            return creator.create();
        }
    }

    private class CglibInterceptorBindingBuilder
    extends AbstractMethodBinder
    implements InterceptorBindingBuilder<T> {
        private CglibInterceptorBindingBuilder() {
        }

        @Override
        public InterceptorCreator<T> using(MethodFilter filter, org.aopalliance.intercept.MethodInterceptor ... interceptors) {
            if (interceptors.length == 0) {
                throw new IllegalArgumentException("Must have at least 1 MethodInterceptor");
            }
            for (Method m : this.getFilteredMethods(filter)) {
                this.map(m, interceptors);
            }
            return new CglibInterceptorCreator(this.getMethodMapper());
        }

        @Override
        public InterceptorCreator<T> using(MethodFilter filter, InterceptorFactory factory) {
            for (Method m : this.getFilteredMethods(filter)) {
                this.map(m, factory);
            }
            return new CglibInterceptorCreator(this.getMethodMapper());
        }

        @Override
        public InterceptorCreator<T> using(Class<? extends Annotation> methodMarker, org.aopalliance.intercept.MethodInterceptor ... interceptors) {
            return this.using(AnnotationFilter.forAnnotation(methodMarker), interceptors);
        }

        @Override
        public MethodBindingBuilder<T> using(Method method, org.aopalliance.intercept.MethodInterceptor ... interceptors) {
            this.map(method, interceptors);
            return new CglibMethodBindingBuilder(this.getMethodMapper());
        }

        private Collection<Method> getFilteredMethods(MethodFilter filter) {
            HashSet<Method> filteredMethods = new HashSet<Method>();
            for (Method m : CglibInterceptorBuilder.this.proxyCreator.getProxyableMethods()) {
                if (!filter.accept(m)) continue;
                filteredMethods.add(m);
            }
            return filteredMethods;
        }
    }

    private abstract class AbstractMethodBinder
    implements MethodBinder<T> {
        private BindingCallbackMapper mapper;

        AbstractMethodBinder() {
            this.mapper = new BindingCallbackMapper();
        }

        AbstractMethodBinder(BindingCallbackMapper mapper) {
            this.mapper = mapper;
        }

        protected BindingCallbackMapper getMethodMapper() {
            return this.mapper;
        }

        protected void map(Method method, org.aopalliance.intercept.MethodInterceptor ... interceptors) {
            this.mapper.bind(method, CglibInterceptorBuilder.this.getCallback(interceptors));
        }

        protected void map(Method method, InterceptorFactory factory) {
            List<org.aopalliance.intercept.MethodInterceptor> interceptors = factory.getInterceptors(method);
            if (interceptors.size() == 0) {
                throw new RuntimeException("InterceptorFactory must return non-empty list of interceptors");
            }
            this.mapper.bind(method, CglibInterceptorBuilder.this.getCallback(interceptors));
        }
    }
}

