/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class InterceptorChain
implements MethodInterceptor {
    private MethodInterceptor[] interceptors;

    public InterceptorChain(List<MethodInterceptor> interceptorList) {
        this.interceptors = interceptorList.toArray(new MethodInterceptor[interceptorList.size()]);
    }

    public InterceptorChain(MethodInterceptor ... interceptors) {
        this.interceptors = interceptors;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        return new InterceptedMethodInvocation(methodInvocation).proceed();
    }

    private class InterceptedMethodInvocation
    implements MethodInvocation {
        MethodInvocation target;
        int index = -1;

        InterceptedMethodInvocation(MethodInvocation target) {
            this.target = target;
        }

        public Method getMethod() {
            return this.target.getMethod();
        }

        public Object[] getArguments() {
            return this.target.getArguments();
        }

        public Object proceed() throws Throwable {
            ++this.index;
            try {
                Object object = this.index == InterceptorChain.this.interceptors.length ? this.target.proceed() : InterceptorChain.this.interceptors[this.index].invoke((MethodInvocation)this);
                return object;
            }
            finally {
                --this.index;
            }
        }

        public Object getThis() {
            return this.target.getThis();
        }

        public AccessibleObject getStaticPart() {
            return this.target.getStaticPart();
        }
    }
}

