/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.proxy4j.core.GenerationException;
import org.proxy4j.core.ProxyFactory;
import org.proxy4j.core.util.DefaultNamingPolicy;
import org.proxy4j.core.util.NamingPolicy;

public abstract class BaseProxyFactory
implements ProxyFactory {
    private WeakReference<ClassLoader> preferredClassLoader;
    private NamingPolicy namingPolicy = new DefaultNamingPolicy();

    public BaseProxyFactory() {
    }

    public BaseProxyFactory(ClassLoader preferredClassLoader) {
        this();
        this.preferredClassLoader = new WeakReference<ClassLoader>(preferredClassLoader);
    }

    protected NamingPolicy getNamingStrategy() {
        return this.namingPolicy;
    }

    @Inject
    public void setNamingStrategy(NamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
    }

    protected ClassLoader getPreferredClassLoader() {
        return this.preferredClassLoader == null ? null : (ClassLoader)this.preferredClassLoader.get();
    }

    protected ClassLoader getProxyClassLoader(Class<?> proxyType) {
        if (this.getPreferredClassLoader() != null) {
            return this.getPreferredClassLoader();
        }
        return proxyType.getClassLoader();
    }

    protected void assertClassVisible(ClassLoader loader, Class<?> type) throws GenerationException {
        Class<?> loadedType = null;
        try {
            loadedType = Class.forName(type.getName(), false, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (loadedType != type) {
            throw new GenerationException(type + " is not visible from class loader");
        }
    }

    protected void assertInterfaces(Class<?> ... types) throws GenerationException {
        for (Class<?> t : types) {
            if (t.isInterface()) continue;
            throw new GenerationException("Class " + t.getCanonicalName() + " is not an interface");
        }
    }

    @Override
    public <T> T createProxy(Class<T> proxyClass, T target, Class<? extends Annotation> marker, MethodInterceptor ... interceptors) throws GenerationException {
        if (interceptors.length == 0) {
            throw new IllegalArgumentException("Must be at least 1 MethodInterceptor");
        }
        return this.buildInterceptor(proxyClass).on(target).using(marker, interceptors).create();
    }
}

