/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.proxy4j.core.struct.WeakHashSet;
import org.proxy4j.core.util.Key;

public final class ClassHashKey
extends Key {
    private final Set<Class<?>> classes = new WeakHashSet();
    private final int hash;

    public ClassHashKey(ClassLoader loader, Class<?> ... classes) {
        this(loader, Arrays.asList(classes));
    }

    public ClassHashKey(ClassLoader loader, Collection<Class<?>> classes) {
        super(loader);
        if (classes.size() == 0) {
            throw new IllegalArgumentException("Must have at least one java.lang.Class to construct the Key");
        }
        this.classes.addAll(classes);
        this.hash = this.internalHash();
    }

    private int internalHash() {
        int result = 17;
        result = 37 * result + this.getClassLoader().hashCode();
        result = 37 * result + this.classes.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassHashKey that = (ClassHashKey)o;
        return this.getClassLoader() != null && this.getClassLoader().equals(that.getClassLoader()) && this.classes.equals(that.classes);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }
}

