/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.struct;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WeakHashSet<T>
extends AbstractSet<T> {
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final Set<WeakElement<T>> wrset;

    public WeakHashSet() {
        this.wrset = new HashSet<WeakElement<T>>();
    }

    public WeakHashSet(int capacity, float loadFactor) {
        this.wrset = new HashSet<WeakElement<T>>(capacity, loadFactor);
    }

    @Override
    public boolean add(T o) {
        this.clearInvalidEntries();
        return this.wrset.add(this.createWeakElement(o));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.clearInvalidEntries();
        boolean b = true;
        for (T t : c) {
            b &= this.wrset.add(this.createWeakElement(t));
        }
        return b;
    }

    @Override
    public void clear() {
        this.wrset.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrset.contains(this.getTempWeakElement(o));
    }

    @Override
    public boolean isEmpty() {
        return this.wrset.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        boolean r = this.wrset.remove(this.getTempWeakElement(o));
        this.clearInvalidEntries();
        return r;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = true;
        for (Object e : c) {
            b &= this.wrset.remove(this.getTempWeakElement(e));
        }
        this.clearInvalidEntries();
        return b;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<WeakElement<T>> internal = this.wrset.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return internal.hasNext();
            }

            @Override
            public T next() {
                return WeakHashSet.this.getReferent((WeakElement)internal.next());
            }

            @Override
            public void remove() {
                internal.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.wrset.size();
    }

    private WeakElement<T> createWeakElement(T elem) {
        return new WeakElement<T>(elem, this.queue);
    }

    private WeakElement<T> getTempWeakElement(T elem) {
        return new WeakElement<T>(elem);
    }

    private void clearInvalidEntries() {
        Reference<T> o;
        while ((o = this.queue.poll()) != null) {
            this.remove(o);
        }
    }

    private T getReferent(WeakElement<T> we) {
        return we == null ? null : (T)we.get();
    }

    private static class WeakElement<T>
    extends WeakReference<T> {
        private final int hashCode;

        public WeakElement(T referent) {
            super(referent);
            this.hashCode = referent.hashCode();
        }

        public WeakElement(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.hashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            Object u;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WeakElement)) {
                return false;
            }
            Object t = this.get();
            return t == (u = ((WeakElement)obj).get()) || t != null && u != null && t.equals(u);
        }
    }
}

