/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.reflect;

import java.lang.reflect.Method;
import java.util.EnumSet;
import org.proxy4j.core.reflect.BaseMethodExtractor;
import org.proxy4j.core.reflect.Modifier;
import org.proxy4j.core.reflect.Visibility;

public abstract class UnitypeMethodExtractor
extends BaseMethodExtractor {
    private Class<?> owningType;

    public UnitypeMethodExtractor(Class<?> owningType) {
        this.owningType = owningType;
    }

    protected String getOwningPackageName() {
        return this.owningType.getPackage().getName();
    }

    protected Class<?> getOwningType() {
        return this.owningType;
    }

    protected boolean isObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("java.lang.Object");
    }

    protected boolean isProxyable(Method method) {
        Visibility methodVisibility = Visibility.getVisibility(method);
        EnumSet<Modifier> modifiers = Modifier.getModifiers(method);
        if (methodVisibility == Visibility.PRIVATE || modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC)) {
            return false;
        }
        return methodVisibility == Visibility.PUBLIC || methodVisibility == Visibility.PROTECTED || this.getPackageName(method.getDeclaringClass()).equals(this.getOwningPackageName());
    }
}

