/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.proxy4j.core.filter.MethodFilter;
import org.proxy4j.core.reflect.BaseMethodExtractor;
import org.proxy4j.core.reflect.SignatureKey;

public class MultitypeMethodExtractor
extends BaseMethodExtractor {
    private SortedSet<Method> methodSet = new TreeSet<Method>(SignatureKey.methodComparator());

    public MultitypeMethodExtractor(Class<?> ... types) {
        for (Class<?> type : types) {
            this.methodSet.addAll(Arrays.asList(type.getMethods()));
        }
    }

    @Override
    public Collection<Method> getProxyableMethods() {
        return this.methodSet;
    }

    @Override
    public Collection<Method> getPublicMethods() {
        return this.methodSet;
    }

    @Override
    public Collection<Method> getMethods(MethodFilter filter) {
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        for (Method m : filteredMethods) {
            if (!filter.accept(m)) continue;
            filteredMethods.add(m);
        }
        return filteredMethods;
    }
}

