/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.proxy4j.core.filter.MethodFilter;
import org.proxy4j.core.reflect.Modifier;
import org.proxy4j.core.reflect.SignatureKey;
import org.proxy4j.core.reflect.UnitypeMethodExtractor;
import org.proxy4j.core.reflect.Visibility;

public class BasicMethodExtractor
extends UnitypeMethodExtractor {
    private SortedSet<Method> methodSet = new TreeSet<Method>(SignatureKey.methodComparator());

    public BasicMethodExtractor(Class<?> owningType) {
        super(owningType);
        this.buildMap();
    }

    private void buildMap() {
        for (Class<?> current = this.getOwningType(); current != null && (this.isIncludeObjectMethods() || !current.getName().equals("java.lang.Object")); current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (!this.isProxyable(m) || this.methodSet.contains(m)) continue;
                this.methodSet.add(m);
            }
        }
    }

    @Override
    public Collection<Method> getProxyableMethods() {
        return this.methodSet;
    }

    @Override
    public Collection<Method> getPublicMethods() {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        for (Method m : this.methodSet) {
            if (Visibility.getVisibility(m) != Visibility.PUBLIC) continue;
            publicMethods.add(m);
        }
        return publicMethods;
    }

    @Override
    public Collection<Method> getMethods(MethodFilter filter) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Method m : this.methodSet) {
            if (!filter.accept(m)) continue;
            results.add(m);
        }
        return results;
    }

    @Override
    protected boolean isProxyable(Method method) {
        Visibility methodVisibility = Visibility.getVisibility(method);
        EnumSet<Modifier> modifiers = Modifier.getModifiers(method);
        if (methodVisibility == Visibility.PRIVATE || modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC)) {
            return false;
        }
        return methodVisibility == Visibility.PUBLIC || methodVisibility == Visibility.PROTECTED || this.getPackageName(method.getDeclaringClass()).equals(this.getOwningPackageName());
    }
}

