/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.jdk;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.proxy4j.core.GenerationException;
import org.proxy4j.core.InterceptorChain;
import org.proxy4j.core.InterceptorFactory;
import org.proxy4j.core.build.InterceptorBindingBuilder;
import org.proxy4j.core.build.InterceptorBuilder;
import org.proxy4j.core.build.InterceptorCreator;
import org.proxy4j.core.build.MethodBindingBuilder;
import org.proxy4j.core.filter.AnnotationFilter;
import org.proxy4j.core.filter.MethodFilter;
import org.proxy4j.core.jdk.JdkMethodInvocation;
import org.proxy4j.core.reflect.InheritableMethodExtractor;
import org.proxy4j.core.reflect.SignatureKey;

class JdkInterceptorBuilder<T>
implements InterceptorBuilder<T> {
    private ClassLoader loader;
    private Class<T> interfaceClass;
    private T target;

    JdkInterceptorBuilder(ClassLoader classLoader, Class<T> interfaceClass) {
        this.loader = classLoader;
        this.interfaceClass = interfaceClass;
    }

    @Override
    public InterceptorBindingBuilder<T> on(T target) {
        this.target = target;
        return new JdkInterceptorBindingBuilder();
    }

    private static class InterceptorInvocationHandler
    implements InvocationHandler {
        private Map<SignatureKey, InterceptorChain> interceptors;
        private Object target;

        InterceptorInvocationHandler(Object target, Map<SignatureKey, InterceptorChain> interceptors) {
            this.target = target;
            this.interceptors = interceptors;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            InterceptorChain chain = this.interceptors.get(new SignatureKey(method));
            if (chain == null) {
                return method.invoke(this.target, args);
            }
            return chain.invoke(new JdkMethodInvocation(this.target, method, args));
        }
    }

    private class JdkInterceptorBindingBuilder
    extends AbstractBindingBuilder
    implements InterceptorBindingBuilder<T> {
        private JdkInterceptorBindingBuilder() {
        }

        @Override
        public InterceptorCreator<T> using(MethodFilter filter, MethodInterceptor ... interceptors) {
            InterceptorChain chain = new InterceptorChain(interceptors);
            for (Method m : JdkInterceptorBuilder.this.interfaceClass.getMethods()) {
                this.bind(m, chain);
            }
            return new JdkInterceptorCreator(this.getMethodMap());
        }

        @Override
        public InterceptorCreator<T> using(MethodFilter filter, InterceptorFactory factory) {
            for (Method m : JdkInterceptorBuilder.this.interfaceClass.getMethods()) {
                this.bind(m, new InterceptorChain(factory.getInterceptors(m)));
            }
            return new JdkInterceptorCreator(this.getMethodMap());
        }

        @Override
        public InterceptorCreator<T> using(Class<? extends Annotation> methodMarker, MethodInterceptor ... interceptors) {
            InterceptorChain chain = new InterceptorChain(interceptors);
            for (Method m : new InheritableMethodExtractor(JdkInterceptorBuilder.this.target.getClass(), JdkInterceptorBuilder.this.interfaceClass).getMethods(AnnotationFilter.forAnnotation(methodMarker))) {
                this.bind(m, chain);
            }
            return new JdkInterceptorCreator(this.getMethodMap());
        }

        @Override
        public MethodBindingBuilder<T> using(Method method, MethodInterceptor ... interceptors) {
            this.bind(method, new InterceptorChain(interceptors));
            return new JdkMethodBindingBuilder(this.getMethodMap());
        }
    }

    private class JdkMethodBindingBuilder
    extends AbstractBindingBuilder
    implements MethodBindingBuilder<T> {
        JdkMethodBindingBuilder(Map<SignatureKey, InterceptorChain> methodMap) {
            super(methodMap);
        }

        @Override
        public T create() throws GenerationException {
            return new JdkInterceptorCreator(this.getMethodMap()).create();
        }

        @Override
        public MethodBindingBuilder<T> using(Method method, MethodInterceptor ... interceptors) {
            this.bind(method, new InterceptorChain(interceptors));
            return this;
        }
    }

    private class JdkInterceptorCreator
    extends AbstractBindingBuilder
    implements InterceptorCreator<T> {
        private Map<SignatureKey, InterceptorChain> methodMap;

        JdkInterceptorCreator(Map<SignatureKey, InterceptorChain> methodMap) {
            this.methodMap = methodMap;
        }

        @Override
        public T create() throws GenerationException {
            return JdkInterceptorBuilder.this.interfaceClass.cast(Proxy.newProxyInstance(JdkInterceptorBuilder.this.loader, new Class[]{JdkInterceptorBuilder.this.interfaceClass}, (InvocationHandler)new InterceptorInvocationHandler(JdkInterceptorBuilder.this.target, this.methodMap)));
        }
    }

    private static class AbstractBindingBuilder {
        private Map<SignatureKey, InterceptorChain> methodMap;

        AbstractBindingBuilder() {
            this.methodMap = new LinkedHashMap<SignatureKey, InterceptorChain>();
        }

        AbstractBindingBuilder(Map<SignatureKey, InterceptorChain> methodMap) {
            this.methodMap = methodMap;
        }

        void bind(Method method, InterceptorChain chain) {
            SignatureKey key = new SignatureKey(method);
            if (this.methodMap.containsKey(key)) {
                throw new IllegalArgumentException("Method already bound to interceptor: " + method.getName());
            }
            this.methodMap.put(key, chain);
        }

        protected Map<SignatureKey, InterceptorChain> getMethodMap() {
            return this.methodMap;
        }
    }
}

