/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.javassist;

import javax.inject.Inject;
import javax.inject.Provider;
import org.proxy4j.core.BaseProxyFactory;
import org.proxy4j.core.GenerationException;
import org.proxy4j.core.ProxyHandler;
import org.proxy4j.core.ProxyLoader;
import org.proxy4j.core.build.InterceptorBuilder;
import org.proxy4j.core.javassist.ClassGenerator;
import org.proxy4j.core.javassist.JavassistInterceptorBuilder;

public class JavassistProxyFactory
extends BaseProxyFactory {
    private final ClassGenerator classGenerator = new ClassGenerator(this.getNamingStrategy());

    public JavassistProxyFactory() {
    }

    @Inject
    public JavassistProxyFactory(@ProxyLoader ClassLoader loader) {
        super(loader);
        this.classGenerator.getClassPool(loader);
    }

    @Override
    public <T> T createProxy(Class<T> proxyType, Provider<T> provider) throws GenerationException {
        try {
            Class<T> proxyClass = this.classGenerator.getProviderProxyClass(this.getProxyClassLoader(proxyType), proxyType);
            return proxyClass.getConstructor(Provider.class).newInstance(provider);
        }
        catch (Exception e) {
            throw new GenerationException("Error creating Provider proxy", e);
        }
    }

    @Override
    public <T> T createProxy(Class<T> proxyType, ProxyHandler<T> handler) throws GenerationException {
        try {
            Class<T> proxyClass = this.classGenerator.getHandlerProxyClass(this.getProxyClassLoader(proxyType), proxyType);
            return proxyClass.getConstructor(ProxyHandler.class).newInstance(handler);
        }
        catch (Exception e) {
            throw new GenerationException("Error creating ProxyHandler proxy", e);
        }
    }

    @Override
    public Object createProxy(Class<?>[] proxyInterfaces, ProxyHandler<?> handler) throws GenerationException {
        this.assertInterfaces(proxyInterfaces);
        try {
            Class<?> proxyClass = this.classGenerator.getHandlerProxyClass(this.getProxyClassLoader(proxyInterfaces[0]), proxyInterfaces);
            return proxyClass.getConstructor(ProxyHandler.class).newInstance(handler);
        }
        catch (Exception e) {
            throw new GenerationException("Error creating ProxyHandler proxy", e);
        }
    }

    @Override
    public <T> InterceptorBuilder<T> buildInterceptor(Class<T> proxyClass) {
        return new JavassistInterceptorBuilder<T>(this.getProxyClassLoader(proxyClass), proxyClass, this.classGenerator);
    }
}

