/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.javassist;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public abstract class JavassistMethodInvocation<T>
implements MethodInvocation {
    private T target;
    private String methodName;
    private Object[] args;

    public JavassistMethodInvocation(T target, String methodName, Object ... args) {
        this.target = target;
        this.methodName = methodName;
        this.args = args;
    }

    public Method getMethod() {
        Class[] argTypes = new Class[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            argTypes[i] = this.args[i].getClass();
        }
        try {
            return this.target.getClass().getMethod(this.methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Invalid MethodInvocation for: " + this.methodName, e);
        }
    }

    public Object[] getArguments() {
        return this.args;
    }

    public T getThis() {
        return this.target;
    }

    public AccessibleObject getStaticPart() {
        return this.getMethod();
    }
}

