/*
 * Decompiled with CFR 0.152.
 */
package org.proxy4j.core.cglib;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.reflect.FastClass;
import org.proxy4j.core.GenerationException;
import org.proxy4j.core.cglib.CallbackMapper;
import org.proxy4j.core.cglib.ClassGenerator;
import org.proxy4j.core.struct.IdentityHashSet;

class ProxyCreator<T> {
    private ClassGenerator<T> generator;
    private Collection<Method> methods;

    ProxyCreator(ClassLoader loader, Class<T> proxyClass) {
        this.generator = ClassGenerator.forType(loader, proxyClass);
        this.methods = this.getMethods(proxyClass, null);
    }

    ProxyCreator(ClassLoader loader, Class<T> proxyClass, Class<?>[] proxyInterfaces) {
        this.generator = ClassGenerator.forTypes(loader, proxyClass, proxyInterfaces);
        this.methods = this.getMethods(proxyClass, proxyInterfaces);
    }

    public Collection<Method> getProxyableMethods() {
        return this.methods;
    }

    private Map<Method, Callback> getCallbackMap(CallbackMapper mapper) {
        HashMap<Method, Callback> callbackMap = new HashMap<Method, Callback>();
        for (Method m : this.methods) {
            callbackMap.put(m, mapper.map(m));
        }
        for (Method m : Object.class.getDeclaredMethods()) {
            if (callbackMap.containsKey(m)) continue;
            callbackMap.put(m, (Callback)NoOp.INSTANCE);
        }
        return callbackMap;
    }

    private Callback[] getCallbacks(Map<Method, Callback> callbackMap) {
        IdentityHashSet<Callback> callbackSet = new IdentityHashSet<Callback>(callbackMap.values());
        return callbackSet.toArray((Callback[])new Callback[callbackSet.size()]);
    }

    private Collection<Method> getMethods(Class<?> superType, Class<?>[] interfaces) {
        ArrayList<Method> mlist = new ArrayList<Method>();
        Enhancer.getMethods(superType, (Class[])interfaces, mlist);
        return mlist;
    }

    T newProxy(CallbackMapper mapper) throws GenerationException {
        Map<Method, Callback> callbackMap = this.getCallbackMap(mapper);
        Callback[] callbacks = this.getCallbacks(callbackMap);
        Class[] callbackClasses = new Class[callbacks.length];
        for (int i = 0; i < callbackClasses.length; ++i) {
            callbackClasses[i] = callbacks[i].getClass();
        }
        Class<T> proxyClass = this.generator.generate(new IndexingCallbackFilter(callbackMap, callbacks), callbackClasses);
        Enhancer.registerCallbacks(proxyClass, (Callback[])callbacks);
        FastClass fc = FastClass.create(proxyClass);
        try {
            T t = proxyClass.cast(fc.newInstance());
            return t;
        }
        catch (Exception e) {
            throw new GenerationException("Error generating proxy instance", e);
        }
        finally {
            Enhancer.registerCallbacks(proxyClass, null);
        }
    }

    private static class IndexingCallbackFilter
    implements CallbackFilter {
        private final Map<Method, Integer> index = new HashMap<Method, Integer>();

        IndexingCallbackFilter(Map<Method, Callback> map, Callback[] callbacks) {
            for (Map.Entry<Method, Callback> e : map.entrySet()) {
                int i = this.indexOf(e.getValue(), callbacks);
                if (i < 0) {
                    throw new IllegalArgumentException("Unmapped method: " + e.getKey());
                }
                this.index.put(e.getKey(), i);
            }
        }

        private int indexOf(Callback callback, Callback[] callbacks) {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] != callback) continue;
                return i;
            }
            return -1;
        }

        public int accept(Method method) {
            return this.index.get(method);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexingCallbackFilter that = (IndexingCallbackFilter)o;
            return this.index.equals(that.index);
        }

        public int hashCode() {
            return this.index.hashCode();
        }
    }
}

