/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PropertyListParser {
    protected PropertyListParser() {
    }

    protected static byte[] readAll(InputStream in, int max) throws IOException {
        int n;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while (max > 0 && (n = in.read()) != -1) {
            buf.write(n);
            --max;
        }
        return buf.toByteArray();
    }

    public static NSObject parse(String filePath) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        return PropertyListParser.parse(new File(filePath));
    }

    public static NSObject parse(File f) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        FileInputStream fis = new FileInputStream(f);
        String magicString = new String(PropertyListParser.readAll(fis, 8), 0, 8);
        fis.close();
        if (magicString.startsWith("bplist")) {
            return BinaryPropertyListParser.parse(f);
        }
        if (magicString.trim().startsWith("(") || magicString.trim().startsWith("{") || magicString.trim().startsWith("/")) {
            return ASCIIPropertyListParser.parse(f);
        }
        return XMLPropertyListParser.parse(f);
    }

    public static NSObject parse(byte[] bytes) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        String magicString = new String(bytes, 0, 8);
        if (magicString.startsWith("bplist")) {
            return BinaryPropertyListParser.parse(bytes);
        }
        if (magicString.trim().startsWith("(") || magicString.trim().startsWith("{") || magicString.trim().startsWith("/")) {
            return ASCIIPropertyListParser.parse(bytes);
        }
        return XMLPropertyListParser.parse(bytes);
    }

    public static NSObject parse(InputStream is) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        if (is.markSupported()) {
            is.mark(10);
            String magicString = new String(PropertyListParser.readAll(is, 8), 0, 8);
            is.reset();
            if (magicString.startsWith("bplist")) {
                return BinaryPropertyListParser.parse(is);
            }
            if (magicString.trim().startsWith("(") || magicString.trim().startsWith("{") || magicString.trim().startsWith("/")) {
                return ASCIIPropertyListParser.parse(is);
            }
            return XMLPropertyListParser.parse(is);
        }
        return PropertyListParser.parse(PropertyListParser.readAll(is, Integer.MAX_VALUE));
    }

    public static void saveAsXML(NSObject root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream fous = new FileOutputStream(out);
        PropertyListParser.saveAsXML(root, fous);
        fous.close();
    }

    public static void saveAsXML(NSObject root, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        w.write(root.toXMLPropertyList());
        w.close();
    }

    public static void convertToXml(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        PropertyListParser.saveAsXML(root, out);
    }

    public static void saveAsBinary(NSObject root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        BinaryPropertyListWriter.write(out, root);
    }

    public static void saveAsBinary(NSObject root, OutputStream out) throws IOException {
        BinaryPropertyListWriter.write(out, root);
    }

    public static void convertToBinary(File in, File out) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        NSObject root = PropertyListParser.parse(in);
        PropertyListParser.saveAsBinary(root, out);
    }

    public static void saveAsASCII(NSDictionary root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toASCIIPropertyList());
        w.close();
    }

    public static void saveAsASCII(NSArray root, File out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toASCIIPropertyList());
        w.close();
    }

    public static void convertToASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        try {
            PropertyListParser.saveAsASCII((NSDictionary)root, out);
        }
        catch (Exception ex) {
            try {
                PropertyListParser.saveAsASCII((NSArray)root, out);
            }
            catch (Exception ex2) {
                throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array!");
            }
        }
    }

    public static void saveAsGnuStepASCII(NSDictionary root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toGnuStepASCIIPropertyList());
        w.close();
    }

    public static void saveAsGnuStepASCII(NSArray root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toGnuStepASCIIPropertyList());
        w.close();
    }

    public static void convertToGnuStepASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        try {
            PropertyListParser.saveAsGnuStepASCII((NSDictionary)root, out);
        }
        catch (Exception ex) {
            try {
                PropertyListParser.saveAsGnuStepASCII((NSArray)root, out);
            }
            catch (Exception ex2) {
                throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array!");
            }
        }
    }
}

