/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.XMLPropertyListParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class PropertyListParser {
    private PropertyListParser() {
    }

    protected static byte[] readAll(InputStream in, int max) throws IOException {
        int n;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while (max > 0 && (n = in.read()) != -1) {
            buf.write(n);
            --max;
        }
        return buf.toByteArray();
    }

    public static NSObject parse(File f) throws Exception {
        FileInputStream fis = new FileInputStream(f);
        String magicString = new String(PropertyListParser.readAll(fis, 8), 0, 8);
        fis.close();
        if (magicString.startsWith("bplist")) {
            return BinaryPropertyListParser.parse(f);
        }
        if (magicString.startsWith("<?xml")) {
            return XMLPropertyListParser.parse(f);
        }
        if (magicString.startsWith("(") || magicString.startsWith("{")) {
            return ASCIIPropertyListParser.parse(f);
        }
        throw new UnsupportedOperationException("The given data is not a valid property list. For supported format see http://code.google.com/p/plist");
    }

    public static NSObject parse(byte[] bytes) throws Exception {
        String magicString = new String(bytes, 0, 8);
        if (magicString.startsWith("bplist")) {
            return BinaryPropertyListParser.parse(bytes);
        }
        if (magicString.startsWith("<?xml")) {
            return XMLPropertyListParser.parse(bytes);
        }
        if (magicString.startsWith("(") || magicString.startsWith("{")) {
            return ASCIIPropertyListParser.parse(bytes);
        }
        throw new UnsupportedOperationException("The given data is not a valid property list. For supported format see http://code.google.com/p/plist");
    }

    public static NSObject parse(InputStream is) throws Exception {
        if (is.markSupported()) {
            is.mark(10);
            String magicString = new String(PropertyListParser.readAll(is, 8), 0, 8);
            is.reset();
            if (magicString.startsWith("bplist")) {
                return BinaryPropertyListParser.parse(is);
            }
            if (magicString.startsWith("<?xml")) {
                return XMLPropertyListParser.parse(is);
            }
            if (magicString.startsWith("(") || magicString.startsWith("{")) {
                return ASCIIPropertyListParser.parse(is);
            }
            throw new UnsupportedOperationException("The given data is not a valid property list. For supported format see http://code.google.com/p/plist");
        }
        return PropertyListParser.parse(PropertyListParser.readAll(is, Integer.MAX_VALUE));
    }

    public static void saveAsXML(NSObject root, File out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "UTF-8");
        w.write(root.toXMLPropertyList());
        w.close();
    }

    public static void convertToXml(File in, File out) throws Exception {
        NSObject root = PropertyListParser.parse(in);
        PropertyListParser.saveAsXML(root, out);
    }

    public static void saveAsBinary(NSObject root, File out) throws IOException {
        BinaryPropertyListWriter.write(out, root);
    }

    public static void convertToBinary(File in, File out) throws Exception {
        NSObject root = PropertyListParser.parse(in);
        PropertyListParser.saveAsBinary(root, out);
    }

    public static void saveAsASCII(NSDictionary root, File out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toASCIIPropertyList());
        w.close();
    }

    public static void saveAsASCII(NSArray root, File out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toASCIIPropertyList());
        w.close();
    }

    public static void convertToASCII(File in, File out) throws Exception {
        NSObject root = PropertyListParser.parse(in);
        try {
            PropertyListParser.saveAsASCII((NSDictionary)root, out);
        }
        catch (Exception ex) {
            try {
                PropertyListParser.saveAsASCII((NSArray)root, out);
            }
            catch (Exception ex2) {
                throw new Exception("The root of the given input property list is neither a Dictionary nor an Array!");
            }
        }
    }

    public static void saveAsGnuStepASCII(NSDictionary root, File out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toGnuStepASCIIPropertyList());
        w.close();
    }

    public static void saveAsGnuStepASCII(NSArray root, File out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toGnuStepASCIIPropertyList());
        w.close();
    }

    public static void convertToGnuStepASCII(File in, File out) throws Exception {
        NSObject root = PropertyListParser.parse(in);
        try {
            PropertyListParser.saveAsGnuStepASCII((NSDictionary)root, out);
        }
        catch (Exception ex) {
            try {
                PropertyListParser.saveAsGnuStepASCII((NSArray)root, out);
            }
            catch (Exception ex2) {
                throw new Exception("The root of the given input property list is neither a Dictionary nor an Array!");
            }
        }
    }
}

