/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSSet
extends NSObject {
    private Set<NSObject> set = new LinkedHashSet<NSObject>();

    public NSSet() {
    }

    public NSSet(NSObject ... objects) {
        this.set.addAll(Arrays.asList(objects));
    }

    public void addObject(NSObject obj) {
        this.set.add(obj);
    }

    public void removeObject(NSObject obj) {
        this.set.remove(obj);
    }

    public NSObject[] allObjects() {
        return this.set.toArray(new NSObject[this.count()]);
    }

    public NSObject anyObject() {
        if (this.set.isEmpty()) {
            return null;
        }
        return this.set.iterator().next();
    }

    public boolean containsObject(NSObject obj) {
        return this.set.contains(obj);
    }

    public NSObject member(NSObject obj) {
        for (NSObject o : this.set) {
            if (!o.equals(obj)) continue;
            return o;
        }
        return null;
    }

    public boolean intersectsSet(NSSet otherSet) {
        for (NSObject o : this.set) {
            if (!otherSet.containsObject(o)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubsetOfSet(NSSet otherSet) {
        for (NSObject o : this.set) {
            if (otherSet.containsObject(o)) continue;
            return false;
        }
        return true;
    }

    public Iterator<NSObject> objectIterator() {
        return this.set.iterator();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.set != null ? ((Object)this.set).hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NSSet other = (NSSet)obj;
        return this.set == other.set || this.set != null && ((Object)this.set).equals(other.set);
    }

    public int count() {
        return this.set.size();
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<array>");
        xml.append(NSObject.NEWLINE);
        for (NSObject o : this.set) {
            o.toXML(xml, level + 1);
            xml.append(NSObject.NEWLINE);
        }
        this.indent(xml, level);
        xml.append("</array>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter out) {
        super.assignIDs(out);
        for (NSObject obj : this.set) {
            obj.assignIDs(out);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.writeIntHeader(12, this.set.size());
        for (NSObject obj : this.set) {
            out.writeID(out.getID(obj));
        }
    }

    @Override
    protected void toASCII(StringBuilder xml, int level) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder xml, int level) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

