/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.jsonpool;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.googlecode.openbox.common.IOUtils;
import com.googlecode.openbox.jsonpool.AbstractJsonStoreLoader;
import com.googlecode.openbox.jsonpool.JsonStoreProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DefaultJsonStoreLoader<K, V>
extends AbstractJsonStoreLoader<K, V> {
    private static final Logger logger = LogManager.getLogger();
    private JsonStoreProvider<K, V> provider;
    private Class<V> classT;

    public DefaultJsonStoreLoader(JsonStoreProvider<K, V> provider, Class<V> classT) {
        this.provider = provider;
        this.classT = classT;
    }

    @Override
    protected List<V> loadJsonObjectFromStore(K k) {
        LinkedList<Object> list = new LinkedList<Object>();
        InputStreamReader fileReader = null;
        BufferedReader lineReader = null;
        try {
            String filePath = this.getStorePath(k);
            File file = new File(filePath);
            fileReader = new FileReader(file);
            lineReader = new BufferedReader(fileReader);
            String jsonString = null;
            while (null != (jsonString = lineReader.readLine())) {
                Object v;
                if ("".equals(jsonString = jsonString.trim()) || null == (v = new Gson().fromJson(jsonString, TypeToken.get(this.classT).getType()))) continue;
                list.add(v);
            }
        }
        catch (Exception e) {
            String message = "load stored Json from file " + this.getStorePath(k) + " encounter error !";
            logger.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        finally {
            if (null != lineReader) {
                try {
                    lineReader.close();
                    fileReader.close();
                }
                catch (IOException e) {
                    logger.error("close file reader error .", (Throwable)e);
                }
            }
        }
        this.sumNum(k, list.size());
        return list;
    }

    @Override
    protected List<V> getJsonObjectsFromProvider(K k, int num) {
        List<V> newJsonObjs = this.provider.get(k, num, this.getCurrentNum(k));
        int actualNum = newJsonObjs.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < actualNum; ++i) {
            sb.append("\n").append(new Gson().toJson(newJsonObjs.get(i)));
        }
        IOUtils.appendContentToFile((String)this.getStorePath(k), (String)sb.toString());
        this.sumNum(k, num);
        return newJsonObjs;
    }

    @Override
    public String getStorePath(K k) {
        return this.provider.getStorePath(k);
    }
}

