/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.samples;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Path;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentedMp4SampleList
extends AbstractList<Sample> {
    Container topLevel;
    IsoFile[] fragments;
    TrackBox trackBox = null;
    TrackExtendsBox trex = null;
    private SoftReference<Sample>[] sampleCache;
    private List<TrackFragmentBox> allTrafs;
    private int size_ = -1;

    public FragmentedMp4SampleList(long track, Container topLevel, IsoFile ... fragments) {
        this.topLevel = topLevel;
        this.fragments = fragments;
        List<TrackBox> trackBoxes = topLevel.getBoxes(MovieBox.class).get(0).getBoxes(TrackBox.class);
        for (TrackBox tb : trackBoxes) {
            if (tb.getTrackHeaderBox().getTrackId() != track) continue;
            this.trackBox = tb;
        }
        if (this.trackBox == null) {
            throw new RuntimeException("This MP4 does not contain track " + track);
        }
        for (Box box : Path.getPaths(topLevel, "moov/mvex/trex")) {
            if (((TrackExtendsBox)box).getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
            this.trex = (TrackExtendsBox)box;
        }
        this.sampleCache = (SoftReference[])Array.newInstance(SoftReference.class, this.size());
    }

    private List<TrackFragmentBox> allFragments() {
        if (this.allTrafs != null) {
            return this.allTrafs;
        }
        LinkedList<TrackFragmentBox> trafs = new LinkedList<TrackFragmentBox>();
        for (MovieFragmentBox moof : this.topLevel.getBoxes(MovieFragmentBox.class)) {
            for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                trafs.add(trackFragmentBox);
            }
        }
        if (this.fragments != null) {
            IsoFile[] isoFileArray = this.fragments;
            int n = this.fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Object fragment = isoFileArray[n2];
                for (MovieFragmentBox moof : ((BasicContainer)fragment).getBoxes(MovieFragmentBox.class)) {
                    for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                        if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                        trafs.add(trackFragmentBox);
                    }
                }
                ++n2;
            }
        }
        this.allTrafs = trafs;
        return trafs;
    }

    private int getTrafSize(TrackFragmentBox traf) {
        return CastUtils.l2i(traf.getBoxes(TrackRunBox.class).get(0).getSampleCount());
    }

    @Override
    public Sample get(int index) {
        Sample cachedSample;
        if (this.sampleCache[index] != null && (cachedSample = this.sampleCache[index].get()) != null) {
            return cachedSample;
        }
        int currentIndex = 1;
        int targetIndex = index + 1;
        for (TrackFragmentBox trackFragmentBox : this.allFragments()) {
            int trafSize = this.getTrafSize(trackFragmentBox);
            if (targetIndex >= currentIndex && targetIndex < currentIndex + trafSize) {
                long sampleSize;
                int sampleIndexWithInTraf = targetIndex - currentIndex;
                MovieFragmentBox moof = (MovieFragmentBox)trackFragmentBox.getParent();
                TrackRunBox trun = trackFragmentBox.getBoxes(TrackRunBox.class).get(0);
                long offset = 0L;
                if (trun.isDataOffsetPresent()) {
                    offset += (long)trun.getDataOffset();
                }
                List<TrackRunBox.Entry> trackRunEntries = trun.getEntries();
                offset = trackFragmentBox.getTrackFragmentHeaderBox().hasBaseDataOffset() ? (offset += trackFragmentBox.getTrackFragmentHeaderBox().getBaseDataOffset()) : (offset += moof.getOffset());
                int i = 0;
                while (i < sampleIndexWithInTraf) {
                    if (trun.isSampleSizePresent()) {
                        offset += trackRunEntries.get(i).getSampleSize();
                    } else if (trackFragmentBox.getTrackFragmentHeaderBox().hasDefaultSampleSize()) {
                        offset += trackFragmentBox.getTrackFragmentHeaderBox().getDefaultSampleSize();
                    } else {
                        if (this.trex == null) {
                            throw new RuntimeException("File doesn't contain trex box but track fragments aren't fully self contained. Cannot determine sample size.");
                        }
                        offset += this.trex.getDefaultSampleSize();
                    }
                    ++i;
                }
                if (trun.isSampleSizePresent()) {
                    sampleSize = trackRunEntries.get(sampleIndexWithInTraf).getSampleSize();
                } else if (trackFragmentBox.getTrackFragmentHeaderBox().hasDefaultSampleSize()) {
                    sampleSize = trackFragmentBox.getTrackFragmentHeaderBox().getDefaultSampleSize();
                } else {
                    if (this.trex == null) {
                        throw new RuntimeException("File doesn't contain trex box but track fragments aren't fully self contained. Cannot determine sample size.");
                    }
                    sampleSize = this.trex.getDefaultSampleSize();
                }
                SampleImpl sample = new SampleImpl(offset, sampleSize, moof.getParent());
                this.sampleCache[index] = new SoftReference<SampleImpl>(sample);
                return sample;
            }
            currentIndex += trafSize;
        }
        return null;
    }

    @Override
    public int size() {
        if (this.size_ != -1) {
            return this.size_;
        }
        int i = 0;
        for (MovieFragmentBox moof : this.topLevel.getBoxes(MovieFragmentBox.class)) {
            for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                i = (int)((long)i + trackFragmentBox.getBoxes(TrackRunBox.class).get(0).getSampleCount());
            }
        }
        IsoFile[] isoFileArray = this.fragments;
        int n = this.fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Object fragment = isoFileArray[n2];
            for (MovieFragmentBox moof : ((BasicContainer)fragment).getBoxes(MovieFragmentBox.class)) {
                for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                    if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                    i = (int)((long)i + trackFragmentBox.getBoxes(TrackRunBox.class).get(0).getSampleCount());
                }
            }
            ++n2;
        }
        this.size_ = i;
        return i;
    }
}

