/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.HttpFileRequester;
import com.googlecode.download.maven.plugin.internal.LoggingProgressReport;
import com.googlecode.download.maven.plugin.internal.SignatureUtils;
import com.googlecode.download.maven.plugin.internal.SilentProgressReport;
import com.googlecode.download.maven.plugin.internal.cache.DownloadCache;
import java.io.File;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.bzip2.BZip2UnArchiver;
import org.codehaus.plexus.archiver.gzip.GZipUnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.snappy.SnappyUnArchiver;
import org.codehaus.plexus.archiver.xz.XZUnArchiver;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="wget", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true)
public class WGet
extends AbstractMojo {
    private static final PoolingHttpClientConnectionManager CONN_POOL = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createSystemDefault(), new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier())).build(), null, null, null, 1L, TimeUnit.MINUTES);
    @Parameter(alias="url", property="download.url", required=true)
    private URI uri;
    @Parameter(property="download.overwrite")
    private boolean overwrite;
    @Parameter(property="download.outputFileName")
    private String outputFileName;
    @Parameter(property="download.outputDirectory", defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="download.verify.md5")
    private String md5;
    @Parameter(property="download.verify.sha1")
    private String sha1;
    @Parameter(property="download.verify.sha256")
    private String sha256;
    @Parameter(property="download.verify.sha512")
    private String sha512;
    @Parameter(property="download.unpack", defaultValue="false")
    private boolean unpack;
    @Parameter(property="download.auth.serverId")
    private String serverId;
    @Parameter(property="download.auth.username")
    private String username;
    @Parameter(property="download.auth.password")
    private String password;
    @Parameter(defaultValue="2")
    private int retries;
    @Parameter(defaultValue="0")
    private int readTimeOut;
    @Parameter(property="download.cache.skip", defaultValue="false")
    private boolean skipCache;
    @Parameter(property="download.cache.directory")
    private File cacheDirectory;
    @Parameter(defaultValue="true")
    private boolean failOnError;
    @Parameter(property="download.plugin.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="checkSignature", defaultValue="false")
    private boolean checkSignature;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private WagonManager wagonManager;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;
    @Parameter(property="runOnlyAtRoot", defaultValue="false")
    private boolean runOnlyAtRoot;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven-download-plugin:wget skipped");
            return;
        }
        if (this.runOnlyAtRoot && !this.project.isExecutionRoot()) {
            this.getLog().info((CharSequence)"maven-download-plugin:wget skipped (not project root)");
            return;
        }
        if (StringUtils.isNotBlank((String)this.serverId) && (StringUtils.isNotBlank((String)this.username) || StringUtils.isNotBlank((String)this.password))) {
            throw new MojoExecutionException("Specify either serverId or username/password, not both");
        }
        if (this.settings == null) {
            this.getLog().warn((CharSequence)"settings is null");
        }
        this.getLog().debug((CharSequence)"Got settings");
        if (this.retries < 1) {
            throw new MojoFailureException("retries must be at least 1");
        }
        if (this.outputFileName == null) {
            try {
                this.outputFileName = new File(this.uri.toURL().getFile()).getName();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Invalid URL", ex);
            }
        }
        if (this.cacheDirectory == null) {
            this.cacheDirectory = new File(this.session.getLocalRepository().getBasedir(), ".cache/download-maven-plugin");
        }
        this.getLog().debug((CharSequence)("Cache is: " + this.cacheDirectory.getAbsolutePath()));
        DownloadCache cache = new DownloadCache(this.cacheDirectory);
        this.outputDirectory.mkdirs();
        File outputFile = new File(this.outputDirectory, this.outputFileName);
        try {
            boolean haveFile = outputFile.exists();
            if (haveFile) {
                boolean signatureMatch = true;
                if (this.checkSignature) {
                    String expectedDigest = null;
                    String algorithm = null;
                    if (this.md5 != null) {
                        expectedDigest = this.md5;
                        algorithm = "MD5";
                    }
                    if (this.sha1 != null) {
                        expectedDigest = this.sha1;
                        algorithm = "SHA1";
                    }
                    if (this.sha256 != null) {
                        expectedDigest = this.sha256;
                        algorithm = "SHA-256";
                    }
                    if (this.sha512 != null) {
                        expectedDigest = this.sha512;
                        algorithm = "SHA-512";
                    }
                    if (expectedDigest != null) {
                        try {
                            SignatureUtils.verifySignature(outputFile, expectedDigest, MessageDigest.getInstance(algorithm));
                        }
                        catch (MojoFailureException e) {
                            this.getLog().warn((CharSequence)("The local version of file " + outputFile.getName() + " doesn't match the expected signature. You should consider checking the specified signature is correctly set."));
                            signatureMatch = false;
                        }
                    }
                }
                if (!signatureMatch) {
                    outputFile.delete();
                    haveFile = false;
                } else if (!this.overwrite) {
                    this.getLog().info((CharSequence)"File already exist, skipping");
                } else {
                    haveFile = false;
                }
            }
            if (!haveFile) {
                File cached = cache.getArtifact(this.uri, this.md5, this.sha1, this.sha256, this.sha512);
                if (!this.skipCache && cached != null && cached.exists()) {
                    this.getLog().info((CharSequence)("Got from cache: " + cached.getAbsolutePath()));
                    Files.copy(cached.toPath(), outputFile.toPath(), new CopyOption[0]);
                } else {
                    boolean done = false;
                    while (!done && this.retries > 0) {
                        try {
                            this.doGet(outputFile);
                            if (this.md5 != null) {
                                SignatureUtils.verifySignature(outputFile, this.md5, MessageDigest.getInstance("MD5"));
                            }
                            if (this.sha1 != null) {
                                SignatureUtils.verifySignature(outputFile, this.sha1, MessageDigest.getInstance("SHA1"));
                            }
                            if (this.sha256 != null) {
                                SignatureUtils.verifySignature(outputFile, this.sha256, MessageDigest.getInstance("SHA-256"));
                            }
                            if (this.sha512 != null) {
                                SignatureUtils.verifySignature(outputFile, this.sha512, MessageDigest.getInstance("SHA-512"));
                            }
                            done = true;
                        }
                        catch (Exception ex) {
                            this.getLog().warn((CharSequence)"Could not get content", (Throwable)ex);
                            --this.retries;
                            if (this.retries <= 0) continue;
                            this.getLog().warn((CharSequence)("Retrying (" + this.retries + " more)"));
                        }
                    }
                    if (!done) {
                        if (this.failOnError) {
                            throw new MojoFailureException("Could not get content");
                        }
                        this.getLog().warn((CharSequence)"Not failing download despite download failure.");
                        return;
                    }
                }
            }
            cache.install(this.uri, outputFile, this.md5, this.sha1, this.sha256, this.sha512);
            if (this.unpack) {
                this.unpack(outputFile);
                this.buildContext.refresh(this.outputDirectory);
            } else {
                this.buildContext.refresh(outputFile);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("IO Error", ex);
        }
    }

    private void unpack(File outputFile) throws NoSuchArchiverException {
        UnArchiver unarchiver = this.archiverManager.getUnArchiver(outputFile);
        unarchiver.setSourceFile(outputFile);
        if (this.isFileUnArchiver(unarchiver)) {
            unarchiver.setDestFile(new File(this.outputDirectory, this.outputFileName.substring(0, this.outputFileName.lastIndexOf(46))));
        } else {
            unarchiver.setDestDirectory(this.outputDirectory);
        }
        unarchiver.extract();
        outputFile.delete();
    }

    private boolean isFileUnArchiver(UnArchiver unarchiver) {
        return unarchiver instanceof BZip2UnArchiver || unarchiver instanceof GZipUnArchiver || unarchiver instanceof SnappyUnArchiver || unarchiver instanceof XZUnArchiver;
    }

    private void doGet(File outputFile) throws Exception {
        SystemDefaultRoutePlanner routePlanner;
        RequestConfig requestConfig;
        if (this.readTimeOut > 0) {
            this.getLog().info((CharSequence)("Read Timeout is set to " + this.readTimeOut + " milliseconds (apprx " + Math.round((double)this.readTimeOut * 1.66667E-5) + " minutes)"));
            requestConfig = RequestConfig.custom().setConnectTimeout(this.readTimeOut).setSocketTimeout(this.readTimeOut).build();
        } else {
            requestConfig = RequestConfig.DEFAULT;
        }
        BasicCredentialsProvider credentialsProvider = null;
        if (StringUtils.isNotBlank((String)this.username)) {
            this.getLog().debug((CharSequence)"providing custom authentication");
            this.getLog().debug((CharSequence)("username: " + this.username + " and password: ***"));
            credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        } else if (StringUtils.isNotBlank((String)this.serverId)) {
            this.getLog().debug((CharSequence)("providing custom authentication for " + this.serverId));
            Server server = this.settings.getServer(this.serverId);
            if (server == null) {
                throw new MojoExecutionException(String.format("Server %s not found", this.serverId));
            }
            this.getLog().debug((CharSequence)String.format("serverId %s supplies username: %s and password: ***", this.serverId, server.getUsername()));
            credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort()), (Credentials)new UsernamePasswordCredentials(server.getUsername(), this.decrypt(server.getPassword(), this.serverId)));
        }
        ProxyInfo proxyInfo = this.wagonManager.getProxy(this.uri.getScheme());
        if (proxyInfo != null && proxyInfo.getHost() != null && "HTTP".equals(proxyInfo.getType())) {
            routePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxyInfo.getHost(), proxyInfo.getPort()));
            if (proxyInfo.getUserName() != null) {
                Object creds = proxyInfo.getNtlmHost() != null || proxyInfo.getNtlmDomain() != null ? new NTCredentials(proxyInfo.getUserName(), proxyInfo.getPassword(), proxyInfo.getNtlmHost(), proxyInfo.getNtlmDomain()) : new UsernamePasswordCredentials(proxyInfo.getUserName(), proxyInfo.getPassword());
                AuthScope authScope = new AuthScope(proxyInfo.getHost(), proxyInfo.getPort());
                if (credentialsProvider == null) {
                    credentialsProvider = new BasicCredentialsProvider();
                }
                credentialsProvider.setCredentials(authScope, (Credentials)creds);
            }
        } else {
            routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)CONN_POOL).setConnectionManagerShared(true).setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        HttpFileRequester fileRequester = new HttpFileRequester(httpClient, this.session.getSettings().isInteractiveMode() ? new LoggingProgressReport(this.getLog()) : new SilentProgressReport(this.getLog()));
        HttpClientContext clientContext = HttpClientContext.create();
        clientContext.setRequestConfig(requestConfig);
        if (credentialsProvider != null) {
            clientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        fileRequester.download(this.uri, outputFile, (HttpContext)clientContext);
    }

    private String decrypt(String str, String server) {
        try {
            return this.securityDispatcher.decrypt(str);
        }
        catch (SecDispatcherException e) {
            this.getLog().warn((CharSequence)String.format("Failed to decrypt password/passphrase for server %s, using auth token as is", server), (Throwable)e);
            return str;
        }
    }
}

