/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileIndex;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;

final class FileBackedIndex
implements FileIndex {
    private final Map<URI, String> index = new HashMap<URI, String>();
    private final File storage;

    FileBackedIndex(File baseDir) {
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Cannot use %s as cache directory: not exist or not a directory", baseDir.getAbsolutePath()));
        }
        File store = new File(baseDir, "index.ser");
        if (store.exists()) {
            this.loadFrom(store);
        } else {
            FileBackedIndex.create(store);
        }
        this.storage = store;
    }

    @Override
    public void put(URI uri, String path) {
        this.index.put(uri, path);
        this.save();
    }

    @Override
    public boolean contains(URI uri) {
        this.loadFrom(this.storage);
        return this.index.containsKey(uri);
    }

    @Override
    public String get(URI uri) {
        if (this.contains(uri)) {
            return this.index.get(uri);
        }
        throw new IllegalStateException("Cache miss. Check for existence with FileIndex#contains before");
    }

    private static void create(File store) {
        try {
            if (!store.createNewFile()) {
                throw new IllegalStateException(String.format("Failed to create index storage file %s", store.getAbsolutePath()));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void loadFrom(File store) {
        if (store.length() != 0L) {
            try (RandomAccessFile file = new RandomAccessFile(store, "r");
                 FileChannel channel = file.getChannel();
                 FileLock lock = channel.lock(0L, Long.MAX_VALUE, true);
                 ObjectInputStream deserialize = new ObjectInputStream(new FileInputStream(store));){
                this.index.clear();
                this.index.putAll((Map)deserialize.readObject());
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void save() {
        try (FileOutputStream file = new FileOutputStream(this.storage);
             ObjectOutputStream res = new ObjectOutputStream(file);
             FileChannel channel = file.getChannel();
             FileLock lock = channel.lock();){
            res.writeObject(this.index);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

