/*
 * Decompiled with CFR 0.152.
 */
package com.google.phonenumbers;

import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberToCarrierMapper;
import com.google.i18n.phonenumbers.PhoneNumberToTimeZonesMapper;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.ShortNumberInfo;
import com.google.i18n.phonenumbers.geocoding.PhoneNumberOfflineGeocoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class PhoneNumberParserServlet
extends HttpServlet {
    private PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private ShortNumberInfo shortInfo = ShortNumberInfo.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String phoneNumber = null;
        String defaultCountry = null;
        String languageCode = "en";
        String regionCode = "";
        String fileContents = null;
        ServletFileUpload upload = new ServletFileUpload();
        upload.setSizeMax(50000L);
        try {
            FileItemIterator iterator = upload.getItemIterator(req);
            while (iterator.hasNext()) {
                FileItemStream item = iterator.next();
                InputStream in = item.openStream();
                if (item.isFormField()) {
                    String fieldName = item.getFieldName();
                    if (fieldName.equals("phoneNumber")) {
                        phoneNumber = Streams.asString((InputStream)in, (String)StandardCharsets.UTF_8.name());
                        continue;
                    }
                    if (fieldName.equals("defaultCountry")) {
                        defaultCountry = Streams.asString((InputStream)in).toUpperCase();
                        continue;
                    }
                    if (fieldName.equals("languageCode")) {
                        String languageEntered = Streams.asString((InputStream)in).toLowerCase();
                        if (languageEntered.length() <= 0) continue;
                        languageCode = languageEntered;
                        continue;
                    }
                    if (!fieldName.equals("regionCode")) continue;
                    regionCode = Streams.asString((InputStream)in).toUpperCase();
                    continue;
                }
                try {
                    fileContents = IOUtils.toString((InputStream)in);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
        catch (FileUploadException e1) {
            e1.printStackTrace();
        }
        resp.setContentType("text/html");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (fileContents == null || fileContents.length() == 0) {
            Locale geocodingLocale = new Locale(languageCode, regionCode);
            resp.sendRedirect(this.getPermaLinkURL(phoneNumber, defaultCountry, geocodingLocale, false));
        } else {
            resp.getWriter().println(this.getOutputForFile(defaultCountry, fileContents));
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String geocodingParam;
        String defaultCountry;
        String phoneNumber = req.getParameter("number");
        if (phoneNumber == null) {
            phoneNumber = "";
        }
        if ((defaultCountry = req.getParameter("country")) == null) {
            defaultCountry = "";
        }
        Locale geocodingLocale = (geocodingParam = req.getParameter("geocodingLocale")) == null ? Locale.ENGLISH : Locale.forLanguageTag(geocodingParam);
        resp.getWriter().println(this.getOutputForSingleNumber(phoneNumber, defaultCountry, geocodingLocale));
    }

    private StringBuilder getOutputForFile(String defaultCountry, String fileContents) {
        StringBuilder output = new StringBuilder("<HTML><HEAD><TITLE>Results generated from phone numbers in the file provided:</TITLE></HEAD><BODY>");
        output.append("<TABLE align=center border=1>");
        output.append("<TH align=center>ID</TH>");
        output.append("<TH align=center>Raw phone number</TH>");
        output.append("<TH align=center>Pretty formatting</TH>");
        output.append("<TH align=center>International format</TH>");
        int phoneNumberId = 0;
        StringTokenizer tokenizer = new StringTokenizer(fileContents, ",");
        while (tokenizer.hasMoreTokens()) {
            String numberStr = tokenizer.nextToken();
            output.append("<TR>");
            output.append("<TD align=center>").append(++phoneNumberId).append(" </TD> \n");
            output.append("<TD align=center>").append(StringEscapeUtils.escapeHtml((String)numberStr)).append(" </TD> \n");
            try {
                Phonenumber.PhoneNumber number = this.phoneUtil.parseAndKeepRawInput(numberStr, defaultCountry);
                boolean isNumberValid = this.phoneUtil.isValidNumber(number);
                String prettyFormat = isNumberValid ? this.phoneUtil.formatInOriginalFormat(number, defaultCountry) : "invalid";
                String internationalFormat = isNumberValid ? this.phoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL) : "invalid";
                output.append("<TD align=center>").append(StringEscapeUtils.escapeHtml((String)prettyFormat)).append(" </TD> \n");
                output.append("<TD align=center>").append(StringEscapeUtils.escapeHtml((String)internationalFormat)).append(" </TD> \n");
            }
            catch (NumberParseException e) {
                output.append("<TD align=center colspan=2>").append(StringEscapeUtils.escapeHtml((String)e.toString())).append(" </TD> \n");
            }
            output.append("</TR>");
        }
        output.append("</BODY></HTML>");
        return output;
    }

    private void appendLine(String title, String data, StringBuilder output) {
        output.append("<TR>");
        output.append("<TH>").append(title).append("</TH>");
        output.append("<TD>").append(data.length() > 0 ? data : "&nbsp;").append("</TD>");
        output.append("</TR>");
    }

    private String getPermaLinkURL(String phoneNumber, String defaultCountry, Locale geocodingLocale, boolean absoluteURL) {
        StringBuilder permaLink = new StringBuilder(absoluteURL ? "http://libphonenumber.appspot.com/phonenumberparser" : "/phonenumberparser");
        try {
            permaLink.append("?number=" + URLEncoder.encode(phoneNumber != null ? phoneNumber : "", StandardCharsets.UTF_8.name()));
            if (defaultCountry != null && !defaultCountry.isEmpty()) {
                permaLink.append("&country=" + URLEncoder.encode(defaultCountry, StandardCharsets.UTF_8.name()));
            }
            if (!geocodingLocale.getLanguage().equals(Locale.ENGLISH.getLanguage()) || !geocodingLocale.getCountry().isEmpty()) {
                permaLink.append("&geocodingLocale=" + URLEncoder.encode(geocodingLocale.toLanguageTag(), StandardCharsets.UTF_8.name()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        return permaLink.toString();
    }

    private String getNewIssueLink(String phoneNumber, String defaultCountry, Locale geocodingLocale) {
        boolean hasDefaultCountry = !defaultCountry.isEmpty() && defaultCountry != "ZZ";
        String issueTitle = "Validation issue with " + phoneNumber + (hasDefaultCountry ? " (" + defaultCountry + ")" : "");
        StringBuilder issueTemplate = new StringBuilder("Please read the \"guidelines for contributing\" (linked above) and fill in the template below.\n\n");
        issueTemplate.append("Country/region affected (e.g., \"US\"): ").append(defaultCountry).append("\n\n");
        issueTemplate.append("Example number(s) affected (\"+1 555 555-1234\"): ").append(phoneNumber).append("\n\n");
        issueTemplate.append("The phone number range(s) to which the issue applies (\"+1 555 555-XXXX\"): \n\n");
        issueTemplate.append("The type of the number(s) (\"fixed-line\", \"mobile\", \"short code\", etc.): \n\n");
        issueTemplate.append("The cost, if applicable (\"toll-free\", \"premium rate\", \"shared cost\"): \n\n");
        issueTemplate.append("Supporting evidence (for example, national numbering plan, announcement from mobile carrier, news article): **IMPORTANT - anything posted here is made public. Read the guidelines first!** \n\n");
        issueTemplate.append("[link to demo](" + this.getPermaLinkURL(phoneNumber, defaultCountry, geocodingLocale, true) + ")\n\n");
        String newIssueLink = "https://github.com/googlei18n/libphonenumber/issues/new?title=";
        try {
            newIssueLink = newIssueLink + URLEncoder.encode(issueTitle, StandardCharsets.UTF_8.name()) + "&body=" + URLEncoder.encode(issueTemplate.toString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        return newIssueLink;
    }

    private StringBuilder getOutputForSingleNumber(String phoneNumber, String defaultCountry, Locale geocodingLocale) {
        StringBuilder output = new StringBuilder("<HTML><HEAD>");
        output.append("<LINK type=\"text/css\" rel=\"stylesheet\" href=\"/stylesheets/main.css\" />");
        output.append("</HEAD>");
        output.append("<BODY>");
        output.append("Phone Number entered: " + StringEscapeUtils.escapeHtml((String)phoneNumber) + "<BR>");
        output.append("defaultCountry entered: " + StringEscapeUtils.escapeHtml((String)defaultCountry) + "<BR>");
        output.append("Language entered: " + StringEscapeUtils.escapeHtml((String)geocodingLocale.toLanguageTag()) + "<BR>");
        try {
            Phonenumber.PhoneNumber number = this.phoneUtil.parseAndKeepRawInput(phoneNumber, defaultCountry);
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>Parsing Result</TD></TR>");
            this.appendLine("country_code", Integer.toString(number.getCountryCode()), output);
            this.appendLine("national_number", Long.toString(number.getNationalNumber()), output);
            this.appendLine("extension", number.getExtension(), output);
            this.appendLine("country_code_source", number.getCountryCodeSource().toString(), output);
            this.appendLine("italian_leading_zero", Boolean.toString(number.isItalianLeadingZero()), output);
            this.appendLine("raw_input", number.getRawInput(), output);
            output.append("</TABLE>");
            output.append("</DIV>");
            boolean isPossible = this.phoneUtil.isPossibleNumber(number);
            boolean isNumberValid = this.phoneUtil.isValidNumber(number);
            PhoneNumberUtil.PhoneNumberType numberType = this.phoneUtil.getNumberType(number);
            boolean hasDefaultCountry = !defaultCountry.isEmpty() && defaultCountry != "ZZ";
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>Validation Results</TD></TR>");
            this.appendLine("Result from isPossibleNumber()", Boolean.toString(isPossible), output);
            if (!isPossible) {
                this.appendLine("Result from isPossibleNumberWithReason()", this.phoneUtil.isPossibleNumberWithReason(number).toString(), output);
                output.append("<TR><TD colspan=2>Note: numbers that are not possible have type UNKNOWN, an unknown region, and are considered invalid.</TD></TR>");
            } else {
                String region;
                this.appendLine("Result from isValidNumber()", Boolean.toString(isNumberValid), output);
                if (isNumberValid && hasDefaultCountry) {
                    this.appendLine("Result from isValidNumberForRegion()", Boolean.toString(this.phoneUtil.isValidNumberForRegion(number, defaultCountry)), output);
                }
                this.appendLine("Phone Number region", (region = this.phoneUtil.getRegionCodeForNumber(number)) == null ? "" : region, output);
                this.appendLine("Result from getNumberType()", numberType.toString(), output);
            }
            output.append("</TABLE>");
            output.append("</DIV>");
            if (!isNumberValid) {
                output.append("<DIV>");
                output.append("<TABLE border=1>");
                output.append("<TR><TD colspan=2>Short Number Results</TD></TR>");
                boolean isPossibleShort = this.shortInfo.isPossibleShortNumber(number);
                this.appendLine("Result from isPossibleShortNumber()", Boolean.toString(isPossibleShort), output);
                if (isPossibleShort) {
                    this.appendLine("Result from isValidShortNumber()", Boolean.toString(this.shortInfo.isValidShortNumber(number)), output);
                    if (hasDefaultCountry) {
                        boolean isPossibleShortForRegion = this.shortInfo.isPossibleShortNumberForRegion(number, defaultCountry);
                        this.appendLine("Result from isPossibleShortNumberForRegion()", Boolean.toString(isPossibleShortForRegion), output);
                        if (isPossibleShortForRegion) {
                            this.appendLine("Result from isValidShortNumberForRegion()", Boolean.toString(this.shortInfo.isValidShortNumberForRegion(number, defaultCountry)), output);
                        }
                    }
                }
                output.append("</TABLE>");
                output.append("</DIV>");
            }
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>Formatting Results</TD></TR>");
            this.appendLine("E164 format", isNumberValid ? this.phoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.E164) : "invalid", output);
            this.appendLine("Original format", this.phoneUtil.formatInOriginalFormat(number, defaultCountry), output);
            this.appendLine("National format", this.phoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.NATIONAL), output);
            this.appendLine("International format", isNumberValid ? this.phoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL) : "invalid", output);
            this.appendLine("Out-of-country format from US", isNumberValid ? this.phoneUtil.formatOutOfCountryCallingNumber(number, "US") : "invalid", output);
            this.appendLine("Out-of-country format from CH", isNumberValid ? this.phoneUtil.formatOutOfCountryCallingNumber(number, "CH") : "invalid", output);
            output.append("</TABLE>");
            output.append("</DIV>");
            AsYouTypeFormatter formatter = this.phoneUtil.getAsYouTypeFormatter(defaultCountry);
            int rawNumberLength = phoneNumber.length();
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>AsYouTypeFormatter Results</TD></TR>");
            for (int i = 0; i < rawNumberLength; ++i) {
                char inputChar = phoneNumber.charAt(i);
                this.appendLine("Char entered: '" + inputChar + "' Output: ", formatter.inputDigit(inputChar), output);
            }
            output.append("</TABLE>");
            output.append("</DIV>");
            if (isNumberValid) {
                output.append("<DIV>");
                output.append("<TABLE border=1>");
                output.append("<TR><TD colspan=2>PhoneNumberOfflineGeocoder Results</TD></TR>");
                this.appendLine("Location", PhoneNumberOfflineGeocoder.getInstance().getDescriptionForNumber(number, geocodingLocale), output);
                output.append("</TABLE>");
                output.append("</DIV>");
                output.append("<DIV>");
                output.append("<TABLE border=1>");
                output.append("<TR><TD colspan=2>PhoneNumberToTimeZonesMapper Results</TD></TR>");
                this.appendLine("Time zone(s)", PhoneNumberToTimeZonesMapper.getInstance().getTimeZonesForNumber(number).toString(), output);
                output.append("</TABLE>");
                output.append("</DIV>");
                if (numberType == PhoneNumberUtil.PhoneNumberType.MOBILE || numberType == PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE || numberType == PhoneNumberUtil.PhoneNumberType.PAGER) {
                    output.append("<DIV>");
                    output.append("<TABLE border=1>");
                    output.append("<TR><TD colspan=2>PhoneNumberToCarrierMapper Results</TD></TR>");
                    this.appendLine("Carrier", PhoneNumberToCarrierMapper.getInstance().getNameForNumber(number, geocodingLocale), output);
                    output.append("</TABLE>");
                    output.append("</DIV>");
                }
            }
            String newIssueLink = this.getNewIssueLink(phoneNumber, defaultCountry, geocodingLocale);
            String guidelinesLink = "https://github.com/googlei18n/libphonenumber/blob/master/CONTRIBUTING.md";
            output.append("<b style=\"color:red\">File an issue</b>: by clicking on <a target=\"_blank\" href=\"" + newIssueLink + "\">this link</a>, I confirm that I " + "have read the <a target=\"_blank\" href=\"" + guidelinesLink + "\">contributor's guidelines</a>.");
        }
        catch (NumberParseException e) {
            output.append(StringEscapeUtils.escapeHtml((String)e.toString()));
        }
        output.append("</BODY></HTML>");
        return output;
    }
}

