/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.LongSerializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.Date;

public class DateSerializer
extends Serializer {
    private static LongSerializer longSerializer = new LongSerializer(true);

    public Date readObjectData(ByteBuffer buffer, Class type) {
        Date date = new Date(LongSerializer.get(buffer, true));
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Read date: " + date));
        }
        return date;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        LongSerializer.put(buffer, ((Date)object).getTime(), true);
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Wrote date: " + object));
        }
    }
}

