/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.compress.ByteArrayCompressor;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class DeflateCompressor
extends ByteArrayCompressor {
    private Deflater deflater = new Deflater();
    private Inflater inflater = new Inflater();

    public DeflateCompressor(Serializer serializer) {
        this(serializer, 2048);
    }

    public DeflateCompressor(Serializer serializer, int bufferSize) {
        super(serializer, bufferSize);
    }

    public void compress(byte[] inputBytes, int inputLength, ByteBuffer outputBuffer) {
        this.deflater.reset();
        this.deflater.setInput(inputBytes, 0, inputLength);
        this.deflater.finish();
        outputBuffer.position(this.deflater.deflate(outputBuffer.array()));
    }

    public void decompress(byte[] inputBytes, int inputLength, ByteBuffer outputBuffer) {
        this.inflater.reset();
        this.inflater.setInput(inputBytes, 0, inputLength);
        try {
            outputBuffer.position(this.inflater.inflate(outputBuffer.array()));
        }
        catch (DataFormatException ex) {
            throw new SerializationException("Error inflating data.", ex);
        }
    }
}

