/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectBuffer {
    private Kryo kryo;
    private final int maxCapacity;
    private ByteBuffer buffer;
    private byte[] bytes;

    public ObjectBuffer(Kryo kryo) {
        this(kryo, 2048, 16384);
    }

    public ObjectBuffer(Kryo kryo, int maxCapacity) {
        this(kryo, maxCapacity, maxCapacity);
    }

    public ObjectBuffer(Kryo kryo, int initialCapacity, int maxCapacity) {
        this.kryo = kryo;
        this.buffer = ByteBuffer.allocate(initialCapacity);
        this.bytes = this.buffer.array();
        this.maxCapacity = maxCapacity;
    }

    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    private void readToBuffer(InputStream input, int contentLength) {
        if (contentLength == -1) {
            contentLength = Integer.MAX_VALUE;
        }
        try {
            int count;
            int position = 0;
            while (position < contentLength && (count = input.read(this.bytes, position, Math.min(this.bytes.length - position, contentLength - position))) != -1) {
                if ((position += count) != this.bytes.length || this.resizeBuffer(true)) continue;
                throw new SerializationException("Buffer limit exceeded: " + this.maxCapacity);
            }
            this.buffer.position(0);
            this.buffer.limit(position);
        }
        catch (IOException ex) {
            throw new SerializationException("Error reading object bytes.", ex);
        }
    }

    public Object readClassAndObject(InputStream input) {
        this.readToBuffer(input, -1);
        return this.kryo.readClassAndObject(this.buffer);
    }

    public Object readClassAndObject(InputStream input, int contentLength) {
        this.readToBuffer(input, contentLength);
        return this.kryo.readClassAndObject(this.buffer);
    }

    public <T> T readObject(InputStream input, Class<T> type) {
        this.readToBuffer(input, -1);
        return this.kryo.readObject(this.buffer, type);
    }

    public <T> T readObject(InputStream input, int contentLength, Class<T> type) {
        this.readToBuffer(input, contentLength);
        return this.kryo.readObject(this.buffer, type);
    }

    public <T> T readObjectData(InputStream input, Class<T> type) {
        this.readToBuffer(input, -1);
        return this.kryo.readObjectData(this.buffer, type);
    }

    public <T> T readObjectData(InputStream input, int contentLength, Class<T> type) {
        this.readToBuffer(input, contentLength);
        return this.kryo.readObjectData(this.buffer, type);
    }

    public void writeClassAndObject(OutputStream output, Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeClassAndObject(this.buffer, object);
            }
            catch (SerializationException ex) {
                if (!ex.causedBy(BufferOverflowException.class)) {
                    throw ex;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), ex);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        this.writeToStream(output);
    }

    public void writeObject(OutputStream output, Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeObject(this.buffer, object);
            }
            catch (SerializationException ex) {
                if (!ex.causedBy(BufferOverflowException.class)) {
                    throw ex;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), ex);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        this.writeToStream(output);
    }

    public void writeObjectData(OutputStream output, Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeObjectData(this.buffer, object);
            }
            catch (SerializationException ex) {
                if (!ex.causedBy(BufferOverflowException.class)) {
                    throw ex;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), ex);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        this.writeToStream(output);
    }

    private void writeToStream(OutputStream output) {
        try {
            output.write(this.bytes, 0, this.buffer.position());
        }
        catch (IOException ex) {
            throw new SerializationException("Error writing object bytes.", ex);
        }
    }

    public Object readClassAndObject(byte[] objectBytes) {
        return this.kryo.readClassAndObject(ByteBuffer.wrap(objectBytes));
    }

    public <T> T readObject(byte[] objectBytes, Class<T> type) {
        return this.kryo.readObject(ByteBuffer.wrap(objectBytes), type);
    }

    public <T> T readObjectData(byte[] objectBytes, Class<T> type) {
        return this.kryo.readObjectData(ByteBuffer.wrap(objectBytes), type);
    }

    public byte[] writeClassAndObject(Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeClassAndObject(this.buffer, object);
            }
            catch (SerializationException ex) {
                if (!ex.causedBy(BufferOverflowException.class)) {
                    throw ex;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), ex);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        return this.writeToBytes();
    }

    public byte[] writeObject(Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeObject(this.buffer, object);
            }
            catch (SerializationException ex) {
                if (!ex.causedBy(BufferOverflowException.class)) {
                    throw ex;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), ex);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        return this.writeToBytes();
    }

    public byte[] writeObjectData(Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeObjectData(this.buffer, object);
            }
            catch (SerializationException ex) {
                if (!ex.causedBy(BufferOverflowException.class)) {
                    throw ex;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), ex);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        return this.writeToBytes();
    }

    private byte[] writeToBytes() {
        byte[] objectBytes = new byte[this.buffer.position()];
        System.arraycopy(this.bytes, 0, objectBytes, 0, objectBytes.length);
        return objectBytes;
    }

    private boolean resizeBuffer(boolean preserveContents) {
        int capacity = this.buffer.capacity();
        if (capacity == this.maxCapacity) {
            return false;
        }
        int newCapacity = Math.min(this.maxCapacity, capacity * 2);
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        byte[] newArray = newBuffer.array();
        if (preserveContents) {
            System.arraycopy(this.bytes, 0, newArray, 0, this.bytes.length);
        }
        this.buffer = newBuffer;
        this.bytes = newArray;
        if (Log.DEBUG) {
            Log.debug((String)"kryo", (String)("Resized ObjectBuffer to: " + newCapacity));
        }
        return true;
    }
}

