/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.googlecode.jsonschema2pojo.Annotator;
import com.googlecode.jsonschema2pojo.DefaultGenerationConfig;
import com.googlecode.jsonschema2pojo.GenerationConfig;
import com.googlecode.jsonschema2pojo.Jackson2Annotator;
import com.googlecode.jsonschema2pojo.SchemaStore;
import com.googlecode.jsonschema2pojo.rules.AdditionalPropertiesRule;
import com.googlecode.jsonschema2pojo.rules.ArrayRule;
import com.googlecode.jsonschema2pojo.rules.DefaultRule;
import com.googlecode.jsonschema2pojo.rules.DescriptionRule;
import com.googlecode.jsonschema2pojo.rules.EnumRule;
import com.googlecode.jsonschema2pojo.rules.FormatRule;
import com.googlecode.jsonschema2pojo.rules.MinItemsMaxItemsRule;
import com.googlecode.jsonschema2pojo.rules.MinLengthMaxLengthRule;
import com.googlecode.jsonschema2pojo.rules.MinimumMaximumRule;
import com.googlecode.jsonschema2pojo.rules.NameHelper;
import com.googlecode.jsonschema2pojo.rules.ObjectRule;
import com.googlecode.jsonschema2pojo.rules.PatternRule;
import com.googlecode.jsonschema2pojo.rules.PropertiesRule;
import com.googlecode.jsonschema2pojo.rules.PropertyRule;
import com.googlecode.jsonschema2pojo.rules.RequiredRule;
import com.googlecode.jsonschema2pojo.rules.Rule;
import com.googlecode.jsonschema2pojo.rules.SchemaRule;
import com.googlecode.jsonschema2pojo.rules.TitleRule;
import com.googlecode.jsonschema2pojo.rules.TypeRule;
import com.googlecode.jsonschema2pojo.rules.ValidRule;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;

public class RuleFactory {
    private final GenerationConfig generationConfig;
    private final Annotator annotator;
    private final SchemaStore schemaStore;
    private final NameHelper nameHelper;

    public RuleFactory(GenerationConfig generationConfig, Annotator annotator, SchemaStore schemaStore) {
        this.generationConfig = generationConfig;
        this.annotator = annotator;
        this.schemaStore = schemaStore;
        this.nameHelper = new NameHelper(generationConfig);
    }

    public RuleFactory() {
        this(new DefaultGenerationConfig(), new Jackson2Annotator(), new SchemaStore());
    }

    public Rule<JPackage, JClass> getArrayRule() {
        return new ArrayRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getDescriptionRule() {
        return new DescriptionRule();
    }

    public Rule<JClassContainer, JType> getEnumRule() {
        return new EnumRule(this);
    }

    public Rule<JType, JType> getFormatRule() {
        return new FormatRule(this);
    }

    public Rule<JPackage, JType> getObjectRule() {
        return new ObjectRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getPropertiesRule() {
        return new PropertiesRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getPropertyRule() {
        return new PropertyRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getRequiredRule() {
        return new RequiredRule(this);
    }

    public Rule<JClassContainer, JType> getTypeRule() {
        return new TypeRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getAdditionalPropertiesRule() {
        return new AdditionalPropertiesRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getTitleRule() {
        return new TitleRule();
    }

    public Rule<JClassContainer, JType> getSchemaRule() {
        return new SchemaRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getDefaultRule() {
        return new DefaultRule();
    }

    public Rule<JFieldVar, JFieldVar> getMinimumMaximumRule() {
        return new MinimumMaximumRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getMinItemsMaxItemsRule() {
        return new MinItemsMaxItemsRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getMinLengthMaxLengthRule() {
        return new MinLengthMaxLengthRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getPatternRule() {
        return new PatternRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getValidRule() {
        return new ValidRule(this);
    }

    public GenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public SchemaStore getSchemaStore() {
        return this.schemaStore;
    }

    public NameHelper getNameHelper() {
        return this.nameHelper;
    }
}

