/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.Rule;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang.StringUtils;

public class PropertyRule
implements Rule<JDefinedClass, JDefinedClass> {
    private final RuleFactory ruleFactory;

    protected PropertyRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JDefinedClass jclass, Schema schema) {
        String propertyName = this.getPropertyName(nodeName);
        JType propertyType = this.ruleFactory.getSchemaRule().apply(nodeName, node, (JClassContainer)jclass, schema);
        node = this.resolveRefs(node, schema);
        JFieldVar field = jclass.field(4, propertyType, propertyName);
        this.ruleFactory.getAnnotator().propertyField(field, jclass, nodeName, node);
        JMethod getter = this.addGetter(jclass, field, nodeName);
        JMethod setter = this.addSetter(jclass, field, nodeName);
        if (this.ruleFactory.getGenerationConfig().isGenerateBuilders()) {
            this.addBuilder(jclass, field);
        }
        if (node.has("title")) {
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), (JDocCommentable)field, schema);
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), (JDocCommentable)getter, schema);
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), (JDocCommentable)setter, schema);
        }
        if (node.has("description")) {
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), (JDocCommentable)field, schema);
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), (JDocCommentable)getter, schema);
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), (JDocCommentable)setter, schema);
        }
        if (node.has("required")) {
            this.ruleFactory.getRequiredRule().apply(nodeName, node.get("required"), (JDocCommentable)field, schema);
            this.ruleFactory.getRequiredRule().apply(nodeName, node.get("required"), (JDocCommentable)getter, schema);
            this.ruleFactory.getRequiredRule().apply(nodeName, node.get("required"), (JDocCommentable)setter, schema);
        }
        if (node.has("pattern")) {
            this.ruleFactory.getPatternRule().apply(nodeName, node.get("pattern"), field, schema);
        }
        this.ruleFactory.getDefaultRule().apply(nodeName, node.get("default"), field, schema);
        this.ruleFactory.getMinimumMaximumRule().apply(nodeName, node, field, schema);
        this.ruleFactory.getMinItemsMaxItemsRule().apply(nodeName, node, field, schema);
        this.ruleFactory.getMinLengthMaxLengthRule().apply(nodeName, node, field, schema);
        if (this.isObject(node) || this.isArrayOfObjects(node, schema)) {
            this.ruleFactory.getValidRule().apply(nodeName, node, field, schema);
        }
        return jclass;
    }

    private JsonNode resolveRefs(JsonNode node, Schema parent) {
        if (node.has("$ref")) {
            Schema refSchema = this.ruleFactory.getSchemaStore().create(parent, node.get("$ref").asText());
            JsonNode refNode = refSchema.getContent();
            return this.resolveRefs(refNode, parent);
        }
        return node;
    }

    private boolean isObject(JsonNode node) {
        return node.has("type") && node.get("type").asText().equals("object");
    }

    private boolean isArrayOfObjects(JsonNode node, Schema parent) {
        return (node = this.resolveRefs(node.path("items"), parent)).path("type").asText().equals("object") || node.path("type").asText().equals("array");
    }

    private JMethod addGetter(JDefinedClass c, JFieldVar field, String jsonPropertyName) {
        JMethod getter = c.method(1, field.type(), this.getGetterName(jsonPropertyName, field.type()));
        JBlock body = getter.body();
        body._return((JExpression)field);
        this.ruleFactory.getAnnotator().propertyGetter(getter, jsonPropertyName);
        return getter;
    }

    private JMethod addSetter(JDefinedClass c, JFieldVar field, String jsonPropertyName) {
        JMethod setter = c.method(1, Void.TYPE, this.getSetterName(jsonPropertyName));
        JVar param = setter.param(field.type(), field.name());
        JBlock body = setter.body();
        body.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
        this.ruleFactory.getAnnotator().propertySetter(setter, jsonPropertyName);
        return setter;
    }

    private JMethod addBuilder(JDefinedClass c, JFieldVar field) {
        JMethod builder = c.method(1, (JType)c, this.getBuilderName(field.name()));
        JVar param = builder.param(field.type(), field.name());
        JBlock body = builder.body();
        body.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
        body._return(JExpr._this());
        return builder;
    }

    private String getPropertyName(String nodeName) {
        nodeName = this.ruleFactory.getNameHelper().replaceIllegalCharacters(nodeName);
        nodeName = this.ruleFactory.getNameHelper().normalizeName(nodeName);
        if (SourceVersion.isKeyword(nodeName)) {
            nodeName = "_" + nodeName;
        }
        if (SourceVersion.isKeyword(nodeName)) {
            nodeName = nodeName + "_";
        }
        return nodeName;
    }

    private String getSetterName(String propertyName) {
        propertyName = this.ruleFactory.getNameHelper().replaceIllegalCharacters(propertyName);
        String setterName = "set" + StringUtils.capitalize((String)this.ruleFactory.getNameHelper().capitalizeTrailingWords(propertyName));
        if (setterName.equals("setClass")) {
            setterName = "setClass_";
        }
        return setterName;
    }

    private String getBuilderName(String propertyName) {
        propertyName = this.ruleFactory.getNameHelper().replaceIllegalCharacters(propertyName);
        return "with" + StringUtils.capitalize((String)this.ruleFactory.getNameHelper().capitalizeTrailingWords(propertyName));
    }

    private String getGetterName(String propertyName, JType type) {
        String prefix = type.equals(type.owner()._ref(Boolean.TYPE)) ? "is" : "get";
        propertyName = this.ruleFactory.getNameHelper().replaceIllegalCharacters(propertyName);
        String getterName = prefix + StringUtils.capitalize((String)this.ruleFactory.getNameHelper().capitalizeTrailingWords(propertyName));
        if (getterName.equals("getClass")) {
            getterName = "getClass_";
        }
        return getterName;
    }
}

