/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.Rule;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.sun.codemodel.JDefinedClass;
import java.util.Iterator;

public class PropertiesRule
implements Rule<JDefinedClass, JDefinedClass> {
    private final RuleFactory ruleFactory;

    protected PropertiesRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JDefinedClass jclass, Schema schema) {
        Iterator properties = node.fieldNames();
        while (properties.hasNext()) {
            String property = (String)properties.next();
            this.ruleFactory.getPropertyRule().apply(property, node.get(property), jclass, schema);
        }
        this.ruleFactory.getAnnotator().propertyOrder(jclass, node);
        return jclass;
    }
}

