/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.SchemaMapper;
import com.googlecode.jsonschema2pojo.exception.ClassAlreadyExistsException;
import com.googlecode.jsonschema2pojo.rules.PrimitiveTypes;
import com.googlecode.jsonschema2pojo.rules.Rule;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Modifier;
import javax.annotation.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ObjectRule
implements Rule<JPackage, JType> {
    private final RuleFactory ruleFactory;

    protected ObjectRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JPackage _package, Schema schema) {
        JDefinedClass jclass;
        JType superType = this.getSuperType(nodeName, node, (JClassContainer)_package, schema);
        if (superType.isPrimitive() || this.isFinal(superType)) {
            return superType;
        }
        try {
            jclass = this.createClass(nodeName, node, _package);
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
        jclass._extends((JClass)superType);
        schema.setJavaTypeIfEmpty((JType)jclass);
        this.addGeneratedAnnotation(jclass);
        if (node.has("title")) {
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), (JDocCommentable)jclass, schema);
        }
        if (node.has("description")) {
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), (JDocCommentable)jclass, schema);
        }
        if (node.has("properties")) {
            this.ruleFactory.getPropertiesRule().apply(nodeName, node.get("properties"), jclass, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeToString()) {
            this.addToString(jclass);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeHashcodeAndEquals()) {
            this.addHashCode(jclass);
            this.addEquals(jclass);
        }
        if (node.has("javaInterfaces")) {
            this.addInterfaces(jclass, node.get("javaInterfaces"));
        }
        this.ruleFactory.getAdditionalPropertiesRule().apply(nodeName, node.get("additionalProperties"), jclass, schema);
        return jclass;
    }

    private JDefinedClass createClass(String nodeName, JsonNode node, JPackage _package) throws ClassAlreadyExistsException {
        JDefinedClass newType;
        try {
            if (node.has("javaType")) {
                String fqn = node.get("javaType").asText();
                if (PrimitiveTypes.isPrimitive(fqn, _package.owner())) {
                    throw new ClassAlreadyExistsException((JType)PrimitiveTypes.primitiveType(fqn, _package.owner()));
                }
                try {
                    Class<?> existingClass = Thread.currentThread().getContextClassLoader().loadClass(fqn);
                    throw new ClassAlreadyExistsException((JType)_package.owner().ref(existingClass));
                }
                catch (ClassNotFoundException e) {
                    newType = _package.owner()._class(fqn);
                }
            } else {
                newType = _package._class(this.getClassName(nodeName, _package));
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new ClassAlreadyExistsException((JType)e.getExistingClass());
        }
        this.ruleFactory.getAnnotator().propertyInclusion(newType, node);
        return newType;
    }

    private boolean isFinal(JType superType) {
        try {
            Class<?> javaClass = Class.forName(superType.fullName());
            return Modifier.isFinal(javaClass.getModifiers());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private JType getSuperType(String nodeName, JsonNode node, JClassContainer jClassContainer, Schema schema) {
        JClass superType = jClassContainer.owner().ref(Object.class);
        if (node.has("extends")) {
            superType = this.ruleFactory.getSchemaRule().apply(nodeName + "Parent", node.get("extends"), jClassContainer, schema);
        }
        return superType;
    }

    private void addGeneratedAnnotation(JDefinedClass jclass) {
        JAnnotationUse generated = jclass.annotate(Generated.class);
        generated.param("value", SchemaMapper.class.getPackage().getName());
    }

    private void addToString(JDefinedClass jclass) {
        JMethod toString = jclass.method(1, String.class, "toString");
        JBlock body = toString.body();
        JInvocation reflectionToString = jclass.owner().ref(ToStringBuilder.class).staticInvoke("reflectionToString");
        reflectionToString.arg(JExpr._this());
        body._return((JExpression)reflectionToString);
        toString.annotate(Override.class);
    }

    private void addHashCode(JDefinedClass jclass) {
        JMethod hashCode = jclass.method(1, Integer.TYPE, "hashCode");
        JBlock body = hashCode.body();
        JInvocation reflectionHashCode = jclass.owner().ref(HashCodeBuilder.class).staticInvoke("reflectionHashCode");
        reflectionHashCode.arg(JExpr._this());
        body._return((JExpression)reflectionHashCode);
        hashCode.annotate(Override.class);
    }

    private void addEquals(JDefinedClass jclass) {
        JMethod equals = jclass.method(1, Boolean.TYPE, "equals");
        JVar otherObject = equals.param(Object.class, "other");
        JBlock body = equals.body();
        JInvocation reflectionEquals = jclass.owner().ref(EqualsBuilder.class).staticInvoke("reflectionEquals");
        reflectionEquals.arg(JExpr._this());
        reflectionEquals.arg((JExpression)otherObject);
        body._return((JExpression)reflectionEquals);
        equals.annotate(Override.class);
    }

    private void addInterfaces(JDefinedClass jclass, JsonNode javaInterfaces) {
        for (JsonNode i : javaInterfaces) {
            jclass._implements(jclass.owner().ref(i.asText()));
        }
    }

    private String getClassName(String nodeName, JPackage _package) {
        String className = this.ruleFactory.getNameHelper().replaceIllegalCharacters(StringUtils.capitalize((String)nodeName));
        String normalizedName = this.ruleFactory.getNameHelper().normalizeName(className);
        return this.makeUnique(normalizedName, _package);
    }

    private String makeUnique(String className, JPackage _package) {
        try {
            JDefinedClass _class = _package._class(className);
            _package.remove((JClass)_class);
            return className;
        }
        catch (JClassAlreadyExistsException e) {
            return this.makeUnique(className + "_", _package);
        }
    }
}

