/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.Rule;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JFieldVar;
import javax.validation.constraints.Size;

public class MinItemsMaxItemsRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    protected MinItemsMaxItemsRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JFieldVar field, Schema currentSchema) {
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations() && (node.has("minItems") || node.has("maxItems"))) {
            JAnnotationUse annotation = field.annotate(Size.class);
            if (node.has("minItems")) {
                annotation.param("min", node.get("minItems").asInt());
            }
            if (node.has("maxItems")) {
                annotation.param("max", node.get("maxItems").asInt());
            }
        }
        return field;
    }
}

