/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.GenerationConfig;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.Rule;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.sun.codemodel.JType;
import java.net.URI;
import java.util.Date;
import java.util.regex.Pattern;

public class FormatRule
implements Rule<JType, JType> {
    private final RuleFactory ruleFactory;

    protected FormatRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JType baseType, Schema schema) {
        if (node.asText().equals("date-time")) {
            return baseType.owner().ref(Date.class);
        }
        if (node.asText().equals("date")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("time")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("utc-millisec")) {
            return this.unboxIfNecessary((JType)baseType.owner().ref(Long.class), this.ruleFactory.getGenerationConfig());
        }
        if (node.asText().equals("regex")) {
            return baseType.owner().ref(Pattern.class);
        }
        if (node.asText().equals("color")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("style")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("phone")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("uri")) {
            return baseType.owner().ref(URI.class);
        }
        if (node.asText().equals("email")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("ip-address")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("ipv6")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("host-name")) {
            return baseType.owner().ref(String.class);
        }
        return baseType;
    }

    private JType unboxIfNecessary(JType type, GenerationConfig config) {
        if (config.isUsePrimitives()) {
            return type.unboxify();
        }
        return type;
    }
}

