/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.Rule;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DefaultRule
implements Rule<JFieldVar, JFieldVar> {
    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JFieldVar field, Schema currentSchema) {
        boolean defaultPresent = node != null && StringUtils.isNotEmpty((String)node.asText());
        String fieldType = field.type().fullName();
        if (fieldType.startsWith(List.class.getName())) {
            field.init(this.getDefaultList(field.type(), node));
        } else if (fieldType.startsWith(Set.class.getName())) {
            field.init(this.getDefaultSet(field.type(), node));
        } else if (defaultPresent) {
            field.init(this.getDefaultValue(field.type(), node));
        }
        return field;
    }

    private JExpression getDefaultValue(JType fieldType, JsonNode node) {
        if (!fieldType.isPrimitive() && node.isNull()) {
            return JExpr._null();
        }
        if ((fieldType = fieldType.unboxify()).fullName().equals(String.class.getName())) {
            return JExpr.lit((String)node.asText());
        }
        if (fieldType.fullName().equals(Integer.TYPE.getName())) {
            return JExpr.lit((int)Integer.parseInt(node.asText()));
        }
        if (fieldType.fullName().equals(Double.TYPE.getName())) {
            return JExpr.lit((double)Double.parseDouble(node.asText()));
        }
        if (fieldType.fullName().equals(Boolean.TYPE.getName())) {
            return JExpr.lit((boolean)Boolean.parseBoolean(node.asText()));
        }
        if (fieldType.fullName().equals(Date.class.getName())) {
            long millisecs = this.parseDateToMillisecs(node.asText());
            JInvocation newDate = JExpr._new((JClass)fieldType.owner().ref(Date.class));
            newDate.arg(JExpr.lit((long)millisecs));
            return newDate;
        }
        if (fieldType.fullName().equals(Long.TYPE.getName())) {
            return JExpr.lit((long)Long.parseLong(node.asText()));
        }
        if (fieldType instanceof JDefinedClass && ((JDefinedClass)fieldType).getClassType().equals(ClassType.ENUM)) {
            return this.getDefaultEnum(fieldType, node);
        }
        return JExpr._null();
    }

    private JExpression getDefaultList(JType fieldType, JsonNode node) {
        JClass listGenericType = (JClass)((JClass)fieldType).getTypeParameters().get(0);
        JClass listImplClass = fieldType.owner().ref(ArrayList.class);
        listImplClass = listImplClass.narrow(listGenericType);
        JInvocation newListImpl = JExpr._new((JClass)listImplClass);
        if (node instanceof ArrayNode && node.size() > 0) {
            JInvocation invokeAsList = fieldType.owner().ref(Arrays.class).staticInvoke("asList");
            for (JsonNode defaultValue : node) {
                invokeAsList.arg(this.getDefaultValue((JType)listGenericType, defaultValue));
            }
            newListImpl.arg((JExpression)invokeAsList);
        }
        return newListImpl;
    }

    private JExpression getDefaultSet(JType fieldType, JsonNode node) {
        JClass setGenericType = (JClass)((JClass)fieldType).getTypeParameters().get(0);
        JClass setImplClass = fieldType.owner().ref(HashSet.class);
        setImplClass = setImplClass.narrow(setGenericType);
        JInvocation newSetImpl = JExpr._new((JClass)setImplClass);
        if (node instanceof ArrayNode) {
            JInvocation invokeAsList = fieldType.owner().ref(Arrays.class).staticInvoke("asList");
            for (JsonNode defaultValue : node) {
                invokeAsList.arg(this.getDefaultValue((JType)setGenericType, defaultValue));
            }
            newSetImpl.arg((JExpression)invokeAsList);
        }
        return newSetImpl;
    }

    private JExpression getDefaultEnum(JType fieldType, JsonNode node) {
        JInvocation invokeFromValue = ((JClass)fieldType).staticInvoke("fromValue");
        invokeFromValue.arg(node.asText());
        return invokeFromValue;
    }

    private long parseDateToMillisecs(String valueAsText) {
        try {
            return Long.parseLong(valueAsText);
        }
        catch (NumberFormatException nfe) {
            try {
                return new StdDateFormat().parse(valueAsText).getTime();
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Unable to parse this string as a date: " + valueAsText);
            }
        }
    }
}

