/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.ContentResolver;
import com.googlecode.jsonschema2pojo.FragmentResolver;
import com.googlecode.jsonschema2pojo.Schema;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SchemaStore {
    private Map<URI, Schema> schemas = new HashMap<URI, Schema>();
    private FragmentResolver fragmentResolver = new FragmentResolver();
    private ContentResolver contentResolver = new ContentResolver();

    public synchronized Schema create(URI id) {
        if (!this.schemas.containsKey(id)) {
            JsonNode content = this.contentResolver.resolve(this.removeFragment(id));
            if (id.toString().contains("#")) {
                content = this.fragmentResolver.resolve(content, '#' + StringUtils.substringAfter((String)id.toString(), (String)"#"));
            }
            this.schemas.put(id, new Schema(id, content));
        }
        return this.schemas.get(id);
    }

    private URI removeFragment(URI id) {
        return URI.create(StringUtils.substringBefore((String)id.toString(), (String)"#"));
    }

    public Schema create(Schema parent, String path) {
        if (path.equals("#")) {
            return parent;
        }
        path = StringUtils.stripEnd((String)path, (String)"#?&/");
        URI id = parent == null || parent.getId() == null ? URI.create(path) : parent.getId().resolve(path);
        return this.create(id);
    }

    public synchronized void clearCache() {
        this.schemas.clear();
    }
}

